% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{search_list}
\alias{search_list}
\title{Perform a search}
\usage{
search_list(query = NULL, type = NULL, offset = NULL, order = NULL,
  owner = NULL, limit = NULL, archived = NULL)
}
\arguments{
\item{query}{string optional. The search query.}

\item{type}{string optional. The type for the search. It accepts a comma-separated list. Valid arguments are listed on the "GET /search/types" endpoint.}

\item{offset}{integer optional. The offset for the search results.}

\item{order}{string optional. The field on which to order the result set.}

\item{owner}{string optional. The owner for the search.}

\item{limit}{integer optional. Defaults to 10. Maximum allowed is 50.}

\item{archived}{string optional. If specified, return only results with the chosen archived status; either 'true', 'false', or 'all'. Defaults to 'false'.}
}
\value{
An array containing the following fields:
\item{totalResults}{integer, The number of items matching the search query.}
\item{aggregations}{object, Aggregations by owner and type for the search results.}
\item{results}{array, An array containing the following fields: 
\itemize{
\item score number, The relevance score from the search request.
\item type string, The type of the item.
\item id integer, The ID of the item.
\item name string, The name of the item.
\item typeName string, The verbose name of the type.
\item updatedAt string, The time the item was last updated.
\item owner string, The owner of the item.
}}
}
\description{
Perform a search
}
