% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{civis_to_multifile_csv}
\alias{civis_to_multifile_csv}
\title{Split a Redshift table into multiple CSV parts on S3}
\usage{
civis_to_multifile_csv(sql, database, job_name = NULL, hidden = TRUE,
  include_header = TRUE, compression = "gzip", delimiter = ",",
  unquoted = FALSE, prefix = NULL)
}
\arguments{
\item{sql}{string, The SQL select string to be executed.}

\item{database}{string, Name of database where query is run.}

\item{job_name}{string, optional. Name to identify scripted sql job.}

\item{hidden}{logical, Whether to hide the query in platform.}

\item{include_header}{logical, optional. Whether to include headers as an
element in the returned list.}

\item{compression}{string, optional, Type of compression to use, if any.
One of 'none', 'zip', or 'gzip'.}

\item{delimiter}{string, optional. Which delimiter to use. One of
',', '\\t' or '|'.}

\item{unquoted}{logical, optional. Whether or not to quote fields.}

\item{prefix}{string, optional. A user specified filename prefix for
the output files to have.}
}
\value{
A list with the items:
\itemize{
  \item header: column headers if 'include_header' is TRUE
  \item query: the executed query
  \item entries: a list containing presigned urls for each csv part
  \item compression: the type of compression on each csv part
  \item delimiter: the delimiter used to seperate fields
  \item unquoted: whether fields are quoted
}
}
\description{
Split a Redshift table into multiple CSV parts on S3 and return their
locations as file IDs and presigned S3 urls.
}
\details{
When tables are large, unloading by splitting them first is faster. When we
split a table, each Redshift compute node can dump its data into
S3 in parallel with the others. By doing so, we avoid having
all compute nodes sending the data through the leader node, which is slow.

This function returns a list that contains the location
of the CSV parts as file IDs and presigned S3 urls. The user can use either
the file IDs or the presigned S3 urls to download the CSV parts. The content
of the list returned by this function is similar to that of the manifest file
returned by Amazon S3 UNLOAD statements.
}
\examples{
\dontrun{
# Download a table into multiple csv parts
sql <- "SELECT * FROM schema.table"
database <- "important_database"
manifest <- civis_to_multifile_csv(sql=sql, database=database)
files <- lapply(manifest[["entries"]], function(x) {
  download_civis(x$id, x$name)
  x$name
})
}
}
