% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cff2r.R
\name{cff2r}
\alias{cff2r}
\title{Convert from CFF into R}
\usage{
cff2r(cffFile = "CITATION.cff", export = FALSE, ...)
}
\arguments{
\item{cffFile}{Path and name of the CFF file}

\item{export}{if `TRUE`, the output is saved as DESCRIPTION (plus an extension to avoid overwriting)}

\item{...}{when \code{export = TRUE}, the user can pass additional arguments
to the \code{exportDESCRIPTION} function. More information in the Details
section.}
}
\value{
A CFF file converted to a DESCRIPTION file.
}
\description{
Converts a CFF file into DESCRIPTION
}
\details{
CFF is a standard format for the citation of software proposed by
Stephan Druskat et. al. (see references below). CFF-compliant files are
stored in files named CITATION.cff.

CITATION.cff files are plain text files with human- and machine-readable
citation information for software. Code developers can include them in their
repositories to let others know how to correctly cite their software.

When \code{export = TRUE}, the user can use the following arguments
to customize the output file:
\describe{
 \item{outname}{The name of the exported file}
 \item{overwrite}{Defaults to \code{FALSE}. If \code{TRUE}, will replace any
   homonymous file present on the export path}
 \item{outpath}{By default, the file is saved to a temporary directory. One
   may provide a different path here. For example, \code{outpath = "."} will
   save to the current working directory}
}
}
\examples{
# Printing converted file onto R session
citation_file <- system.file("CFF-CITATION.cff", package = "citation")
cff2r(citation_file)

# Saving converted file to temporary folder on system
tempFolder <- tempdir()
cff2r(
 citation_file, export = TRUE, outname = "converted-desc", overwrite = TRUE,
 outpath = tempFolder
)

# Making sure the file is indeed there
cat(readLines(file.path(tempFolder, "converted-desc")), sep="\n")
}
\references{
Druskat S., Spaaks J.H., Chue Hong N., Haines R., Baker J. (2019).
Citation File Format (CFF) (version 1.1.0).
DOI: http://doi.org/10.5281/zenodo.1003149

https://www.software.ac.uk/blog/2017-12-12-standard-format-citation-files
https://citation-file-format.github.io
https://github.com/citation-file-format/citation-file-format/blob/master/README.md
https://citation-file-format.github.io/cff-initializer-javascript/
}
\seealso{
r2cff
}
\author{
Waldir Leoncio
}
