% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circGLMClassFunctions.R
\name{predict_function.circGLM}
\alias{predict_function.circGLM}
\title{Obtain a prediction function from a circGLM object}
\usage{
predict_function.circGLM(object, linkfun = function(x) atanLF(x, 2))
}
\arguments{
\item{object}{A \code{circGLM} object.}

\item{linkfun}{A link function to use in the analysis. Should be the same as
the link function.}
}
\value{
A function that takes \code{newdata} as an argument, which must be a
  data frame with predictors. The predictors must be the same as used in the
  \code{circGLM} object and must have the same column names.
}
\description{
This functions creates and returns a new prediction \code{function} that
takes in new data, and returns their predicted values. The prediction
function is based on the posterior estimates.
}
\examples{
dat <- generateCircGLMData()
m   <- circGLM(th ~ ., dat)
predfun <- predict_function.circGLM(m)
newd <- generateCircGLMData()

# Predicted values of the new data.
predfun(newd)
}
