% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circGLM.R
\name{estimateDensityBySpline}
\alias{estimateDensityBySpline}
\title{Estimate the density value from a sample by a spline interpolation of the
kernel density}
\usage{
estimateDensityBySpline(x, x0 = 0, npow = 15, rangeExtend = 1/4)
}
\arguments{
\item{x}{A (large) sample of from the probability density function of
interest, such as a posterior.}

\item{x0}{The value at which to evaluate the density.}

\item{npow}{The precision used with the \code{density} function.}

\item{rangeExtend}{The number of standard deviations past the range of
\code{x} to start the density estimate.}
}
\value{
Numeric; a scalar of the estimated probability density at \code{x0}.
}
\description{
This function estimates the density at \code{x0} by first taking a kernel
density estimate of a sample from the probability density \code{x}, and then
interpolating it by a spline.
}
\examples{
# Compare the estimate from this function with the analytic result.
estimateDensityBySpline(rnorm(1000), 0.1)
dnorm(.1)

}
