% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment_functions.R
\name{run_enrichment}
\alias{run_enrichment}
\title{run_enrichment}
\usage{
run_enrichment(
  results,
  geneset = NULL,
  experiment.type = "ATAC-Seq",
  reference.genome = NULL,
  enrichment.method = NULL,
  enrichment.FDR.cutoff = 1,
  background.genes.size = 20000,
  verbose = TRUE
)
}
\arguments{
\item{results}{list, DA peaks list for different contrasts}

\item{geneset}{Pathways to be used in enrichment analyses. If not set vp2008 (Chaussabel, 2008)
immune modules will be used. This can be set to any geneset using `read.gmt` function from `qusage`
package. Different modules are available: https://www.gsea-msigdb.org/gsea/downloads.jsp.}

\item{experiment.type}{The type of experiment either set to "ATAC-Seq" or "RNA-Seq"}

\item{reference.genome}{genome of interested species. It should be 'hg38', 'hg19' or 'mm10'.}

\item{enrichment.method}{There are two methodologies for enrichment analyses,
Hyper-geometric p-value (HPEA) or Geneset Enrichment Analyses (GSEA).}

\item{enrichment.FDR.cutoff}{FDR cut-off for enriched terms, p-values
are corrected by Benjamini-Hochberg procedure}

\item{background.genes.size}{number of background genes for hyper-geometric p-value
calculations. Default is 20,000.}

\item{verbose}{prints messages through running the pipeline}
}
\value{
list, enrichment analyses results along with corresponding differential analyses outcomes
}
\description{
This function is run, if the enrichment pipeline wants to be called afterwards.
Setting reference genome to the same genome which cinaR was run should be given to this function!
}
\examples{
\donttest{
library(cinaR)
data(atac_seq_consensus_bm) # calls 'bed'

# a vector for comparing the examples
contrasts <- sapply(strsplit(colnames(bed), split = "-", fixed = TRUE),
                    function(x){x[1]})[4:25]

results <- cinaR(bed, contrasts, reference.genome = "mm10", run.enrichment = FALSE)

results_with_enrichment <- run_enrichment(results, reference.genome = "mm10")
}
}
