% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_functions.R
\name{heatmap_differential}
\alias{heatmap_differential}
\title{heatmap_differential}
\usage{
heatmap_differential(results, comparison = NULL, ...)
}
\arguments{
\item{results}{cinaR result object}

\item{comparison}{these are created by cinaR from `contrasts` user provided. If not selected the first comparison will be shown!}

\item{...}{additional arguments for heatmap function, for more info `?pheatmap`}
}
\value{
ggplot object
}
\description{
plot differentially accessible peaks for a given comparison
}
\examples{
\donttest{
library(cinaR)
data(atac_seq_consensus_bm) # calls 'bed'

# a vector for comparing the examples
contrasts <- sapply(strsplit(colnames(bed), split = "-", fixed = TRUE),
                    function(x){x[1]})[4:25]

results <- cinaR(bed, contrasts, reference.genome = "mm10")

heatmap_differential(results)
}
}
