% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.r
\name{cimis_split_query}
\alias{cimis_split_query}
\title{Split CIMIS Query}
\usage{
cimis_split_query(targets, start.date, end.date, items,
  max.records = 1750L)
}
\arguments{
\item{targets}{geographies or weather stations of interest. This
parameter may specify one or many stations, zip codes,
coordinates, or street addresses; however, you are not allowed to
mix values from different categories. This means the targets
parameter must contain only stations, only zip codes, only
coordinates, or only street addresses. You will receive an error
if you attempt to mix different category types. The formats are
accepted:
\itemize{
\item A comma delimited list of WSN station numbers
\item A comma delimited list of California zip codes
\item A semicolon delimited list of decimal - degree coordinates
\item A semicolon delimited list of street addresses
}}

\item{start.date}{Specifies the start date. The data format is
\code{"yyyy-mm-dd"}.}

\item{end.date}{Specifies the end date. The data format is
\code{"yyyy-mm-dd"}.}

\item{items}{specifies one or more comma-delimited data elements to
include in your response. See \code{data_items()} for a complete list
of possible data element values. Default: day-asce-eto,
day-precip, day-sol-rad-avg, day-vap-pres-avg, day-air-tmp-max,
day-air-tmp-min, day-air-tmp-avg, day-rel-hum-max,
day-rel-hum-min, day-rel-hum-avg, day-dew-pnt, day-wind-spd-avg,
day-wind-run, day-soil-tmp-avg.}

\item{max.records}{The maximum number of records returned by a query.
The default value is the the maximum data limit allowed by the
CIMIS Web API (1,750 records).}
}
\value{
A data frame with columns "targets", "start.date", "end.date", and
"items".
}
\description{
Split a large CIMIS query into multiple smaller queries based on a
time interval.
}
\details{
Queries are not split by \code{targets} or \code{items}, i.e. each resulting
query will include all targets and items.
}
\examples{
cimis_split_query(170, "2000-01-01", "2010-12-31", "day-air-tmp-avg")
cimis_split_query(c(149, 170), "2018-01-01", "2018-12-31", 
  c("day-air-tmp-avg", "hly-air-tmp", "hly-rel-hum"))

}
