% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample_gifti.R
\name{resample_gifti}
\alias{resample_gifti}
\alias{resampleGIfTI}
\alias{resamplegii}
\title{Resample a metric GIFTI file (with its ROI)}
\usage{
resample_gifti(
  original_fname,
  target_fname,
  hemisphere = c("left", "right"),
  file_type = NULL,
  original_res = NULL,
  resamp_res,
  ROIcortex_original_fname = NULL,
  ROIcortex_target_fname = NULL,
  read_dir = NULL,
  write_dir = NULL
)

resampleGIfTI(
  original_fname,
  target_fname,
  hemisphere,
  file_type = NULL,
  original_res = NULL,
  resamp_res,
  ROIcortex_original_fname = NULL,
  ROIcortex_target_fname = NULL,
  read_dir = NULL,
  write_dir = NULL
)

resamplegii(
  original_fname,
  target_fname,
  hemisphere,
  file_type = NULL,
  original_res = NULL,
  resamp_res,
  ROIcortex_original_fname = NULL,
  ROIcortex_target_fname = NULL,
  read_dir = NULL,
  write_dir = NULL
)
}
\arguments{
\item{original_fname}{The GIFTI file to resample.}

\item{target_fname}{Where to save the resampled file.}

\item{hemisphere}{\code{"left"} (default) or \code{"right"}. An error will
occur if the hemisphere indicated in the GIFTI metadata does not match.}

\item{file_type}{\code{"metric"}, \code{"label"}, \code{"surf"}, or \code{NULL}
(default) to infer from \code{original_fname}.}

\item{original_res}{The resolution of the original file. If \code{NULL}
(default), infer from the file.}

\item{resamp_res}{Target resolution for resampling (number of
cortical surface vertices per hemisphere).}

\item{ROIcortex_original_fname}{The name of the ROI file corresponding to
\code{original_fname}. Leave as \code{NULL} (default) if this doesn't exist
or shouldn't be resampled.}

\item{ROIcortex_target_fname}{The name of the resampled ROI file. Only
applicable if \code{ROIcortex_original_fname} is provided.}

\item{read_dir}{Directory to append to the path of every file name in
\code{original_fname} and \code{ROIcortex_original_fname}. If \code{NULL}
(default), do not append any directory to the path.}

\item{write_dir}{Directory to append to the path of every file name in
\code{target_fname} and \code{ROIcortex_target_fname}. If \code{NULL}
(default), do not append any directory to the path.}
}
\value{
The resampled GIFTI file name, invisibly
}
\description{
Performs spatial resampling of GIFTI data on the cortical surface.
}
