% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_surf.R
\name{mask_with_boundary_surf}
\alias{mask_with_boundary_surf}
\title{Apply Mask With Boundary To Mesh}
\usage{
mask_with_boundary_surf(
  vertices,
  faces,
  mask,
  width1 = 4,
  k1 = 2,
  width2 = 6,
  k2 = 3
)
}
\arguments{
\item{vertices}{A \eqn{V \times 3} matrix, where each row contains the Euclidean
coordinates at which a given vertex in the mesh is located. \eqn{V} is the
number of vertices in the mesh}

\item{faces}{An \eqn{F \times 3} matrix, where each row contains the vertex
indices for a given triangular face in the mesh. \eqn{F} is the number of
faces in the mesh.}

\item{mask}{A length \eqn{V} logical vector indicating if each vertex is
within the input mask.}

\item{width1, width2}{the width of the middle/outer region. All vertices in the middle/outer region
are between 1 and \code{width1} edges away from the closest vertex in \code{mask}/middle region.}

\item{k1, k2}{roughly, the triangle size multiplier. Every \code{k1}/\code{k2} vertex within
every \code{k1}/\code{k2} layer (beginning with the innermost layer) will be retained;
the rest will be discarded. If the mesh originally has triangles of regular
size, the sides of the triangles in the middle/outer region will be about
\code{k1}/\code{k2} as long.}
}
\value{
A new mesh (list with components vertices and faces)
}
\description{
Make a boundary around a mask with two levels of decimation, and apply to a mask.
}
\details{
The boundary consists of a \code{width1}-vertex-wide middle region and a
\code{width2}-vertex-wide outer region, for a total of \code{width1 + width2} layers
of vertices surrounding the input mask. In the first layer, every \code{k1}
vertex within every \code{k1} layer (beginning with the innermost
layer) is retained; the rest are discarded. In the second layer, every
\code{k2} vertex within every \code{k2} layer (beginning with the innermost
layer) is retained; the rest are discarded. It is recommended to make \code{width1}
a multiple of \code{k1} and \code{width2} a multiple of \code{k2}.

Default boundary: a 4-vertex wide middle region with triangles twice as long,
and a 6-vertex wide outer region with triangles three times as long.
}
\keyword{internal}
