% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_surf.R
\name{view_surf}
\alias{view_surf}
\title{View \code{"surf"} object(s)}
\usage{
view_surf(
  ...,
  view = c("both", "lateral", "medial"),
  widget = NULL,
  title = NULL,
  fname = FALSE,
  cex.title = NULL,
  text_color = "black",
  bg = NULL,
  alpha = 1,
  edge_color = NULL,
  vertex_color = NULL,
  vertex_size = 0,
  material = NULL,
  width = NULL,
  height = NULL,
  zoom = NULL
)
}
\arguments{
\item{...}{One of: A \code{"surf"} object; two \code{"surf"} objects;
or, a \code{"xifti"} object. If a \code{"surf"} object has an empty
\code{"hemisphere"} metadata entry, it will be set to the opposite side
of the other's if known; otherwise, it will be set to the left side. If both
are unknown, the first will be taken as the left and the second as the
right.}

\item{view}{Which view to display: \code{"lateral"}, \code{"medial"}, or
\code{"both"}. If \code{NULL} (default), both views will be shown. Each view
will be plotted in a separate panel row.}

\item{widget}{Display the plot in an htmlwidget? Should be logical or
\code{NULL} (default), in which case a widget will be used only if needed
(\code{length(idx)>1 & isFALSE(fname)}, \code{fname} is a file path to an
.html file, or if \code{rgl.useNULL()}).}

\item{title}{Optional title(s) for the plot(s). It will be printed at the top
in a separate subplot with 1/4 the height of the brain cortex subplots.

Default: \code{NULL} will not use any title if \code{length(idx)==1}.
Otherwise, it will use the time index (".dtseries") or name
(.dscalar or .dlabel) of each data column.

To use a custom title(s), use a length 1 character vector (same title for
each plot) or length \code{length(idx)} character vector (different title
for each plot). Set to \code{NULL} or an empty character to omit the title.

If the title is non-empty but does not appear, try lowering \code{cex.title}.}

\item{fname}{Save the plot(s) (and color legend if applicable)?

If \code{isFALSE(fname)} (default), no files will be written.

If \code{fname} is a length-1 character vector ending in ".html", an html
with an interactive widget will be written.

If neither of the cases above apply, a png image will be written for each
\code{idx}. If \code{isTRUE(fname)} the files will be named by the
data column names (underscores will replace spaces). Or, set \code{fname} to a
length 1 character vector to name files by this suffix followed by the
\code{fname_suffix}. Or, set \code{fname} to a character vector with the same
length as \code{idx} to name the files exactly.}

\item{cex.title}{Font size multiplier for the title. \code{NULL} (default)
will use \code{2} for titles less than 20 characters long, and smaller
sizes for increasingly longer titles.}

\item{text_color}{Color for text in title and colorbar legend. Default:
\code{"black"}.}

\item{bg}{Background color. \code{NULL} will use \code{"white"}. Does not affect
the color legend or color bar if printed separately: those will always have
white backgrounds.}

\item{alpha}{Transparency value for mesh coloring, between 0 and 1. Default:
\code{1.0} (no transparency).}

\item{edge_color}{Outline each edge in this color. Default: \code{NULL} (do
not outline the edges).}

\item{vertex_color}{Draw each vertex in this color. Default:
\code{"black"}. Vertices are only drawn if \code{vertex_size > 0}}

\item{vertex_size}{Draw each vertex with this size. Default: \code{0}
(do not draw the vertices).}

\item{material}{A list of materials from \code{\link[rgl]{material3d}}
to use. For example, \code{list(lit=FALSE, smooth=FALSE)} will use exact colors
from the color scale, rather than adding geometric shading and interpolating
vertex colors. If \code{NULL}, use defaults.}

\item{width, height}{The dimensions of the RGL window, in pixels. If both are
\code{NULL} (default), these dimensions depend on type of output (Open GL
window or widget) and subplots (\code{hemisphere}, \code{view}, \code{title},
and \code{slider_title}) and are chosen to be the largest plot within a
1500 x 700 area (Open GL window) or 600 x 700 area (widget) that maintains
a brain hemisphere subplot dimensions ratio of 10 x 7. Specifying only one
will set the other to maintain this aspect ratio. Both can be specified to
set the dimensions exactly, but note that the dimensions cannot be larger
than the screen resolution. (These arguments do not affect the size of the
legend, which cannot be controlled.)

The plot will be taller than \code{height} to accommodate a title or color
bar.

If multiple \code{idx} are being composited with \code{together}, these
arguments refer to a single \code{idx} within the composited plot, and not
the composited plot itself.}

\item{zoom}{Adjust the sizes of the brain meshes. Default: \code{NULL} (will
be set to 0.6 or 160\\% for the Open GL window, and 0.67 or 167\\% for the
widget.)}
}
\description{
Visualize one or two \code{"surf"} objects(s), or the \code{"surf"}
component(s) in a \code{"xifti"} using an interactive Open GL window
made with \code{rgl}. The \code{rgl} package is required.
}
\details{
This function works as a wrapper to \code{\link{view_xifti_surface}}, but
some arguments are not applicable (e.g. color scheme and legend). Also,
instead of using the \code{hemisphere} argument, name the surface arguments
\code{surfL} or \code{surfR} (see description for parameter \code{...}).
Finally, the default value for \code{param} is \code{"surf"}, not
\code{"xifti"}.
}
\section{Navigating and Embedding the Interactive Plots}{


To navigate the interactive Open GL window and html widget, left click and
drag the cursor to rotate the meshes. Use the scroll wheel or right click
and drag to zoom. Press the scroll wheel and drag to change the field-of-view.
For Open GL windows, execute
\code{\link[rgl]{snapshot}} to save the current window as a .png file,
\code{\link[rgl:open3d]{close3d}} to close the window, and
\code{\link[rgl:viewpoint]{view3d}} to programmatically control the
perspective.

To embed an interactive plot in an R Markdown document, first execute
\code{rgl::setupKnitr()} to prepare the document for embedding the widget.
Then execute the plot command as you normally would to create a widget (i.e.
without specifying \code{fname}, and by requesting more than one \code{idx}
or by setting \code{widget} to \code{TRUE}). When the R Markdown document is
knitted, the interactive widget should be displayed below the chunk in which
the plot command was executed. See the vignette for an example.
}

\section{Embedding the Static Plots}{


To embed a static plot in an R Markdown document, first execute
\code{rgl::setupKnitr()} to prepare the document for embedding the snapshot
of the Open GL window. Then execute the plot command as you normally would
to create an Open GL window (i.e. without specifying \code{fname}, and by
requesting only one \code{idx}). In the options for the chunk in which the
plot command is executed, set \code{rgl=TRUE, format="png"}. You can also
control the image dimensions here e.g. \code{fig.height=3.8, fig.width=5}.
When the R Markdown document is knitted, the static plots should be
displayed below the chunk in which the plot command was executed. See the
vignette for an example.
}

\seealso{
Other visualizing: 
\code{\link{view_comp}()},
\code{\link{view_xifti_surface}()},
\code{\link{view_xifti_volume}()},
\code{\link{view_xifti}()}

Other surface-related: 
\code{\link{add_surf}()},
\code{\link{boundary_mask_surf}()},
\code{\link{edit_mask_surf}()},
\code{\link{even_vert_samp}()},
\code{\link{is.surf}()},
\code{\link{load_surf}()},
\code{\link{mask_surf}()},
\code{\link{read_surf}()},
\code{\link{resample_surf}()},
\code{\link{rotate_surf}()},
\code{\link{surf_area}()},
\code{\link{write_surf_gifti}()}
}
\concept{surface-related}
\concept{visualizing}
