% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cifti_flat.R
\name{read_cifti_flat}
\alias{read_cifti_flat}
\title{Read only the data matrix in a CIFTI file}
\usage{
read_cifti_flat(
  cifti_fname,
  keep = FALSE,
  gifti_fname = NULL,
  idx = NULL,
  write_dir = NULL
)
}
\arguments{
\item{cifti_fname}{File path to a CIFTI file (ending in ".d*.nii").}

\item{keep}{This function works by converting the CIFTI file to a GIFTI file
and then reading it in. Should the GIFTI file be kept? If \code{FALSE}
(default), write it in a temporary directory regardless of \code{write_dir}.}

\item{gifti_fname}{File path of GIFTI-format data to save the CIFTI as.
Should end with ".func.gii" for dscalar and dtseries CIFTI, and ".label.gii"
for dlabel CIFTI. Default: the CIFTI_fname but with the CIFTI extension
replaced with the appropriate GIFTI extension.}

\item{idx}{Numeric vector indicating the data indices (columns) to read. If
\code{NULL} (default), read in all the data. Must be a subset of the indices
present in the file, or an error will occur.

For high-resolution CIFTI files, reading in only a subset of the data saves
memory, but will be slower than reading in the entire file due to the
required intermediate steps.}

\item{write_dir}{The directory in which to save the GIFTI, if it is being
kept. If \code{NULL} (default), use the current working directory.}
}
\value{
A \eqn{T x G} matrix, where \eqn{T} is the number of measurements
and \eqn{G} is the number of grayordinates in the CIFTI file.
}
\description{
Reads the CIFTI data matrix by converting it to a GIFTI using the
\code{-cifti-convert -to-gifti-ext} Connectome Workbench command. The result
will be a \eqn{T x G} matrix (\eqn{T} measurements, \eqn{G} non-empty
grayordinates). All brainstructures in the CIFTI will be obtained, with no
indication for which brainstructure each brainordinate corresponds to.
Medial wall vertices and voxels outside the subcortical mask will not be
included. No spatial information is included. This is the fastest way to
read in CIFTI data.
}
\keyword{internal}
