% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pi_negbin.R
\name{add_pi.negbin}
\alias{add_pi.negbin}
\title{Prediction Intervals for Negative Binomial Linear Models}
\usage{
\method{add_pi}{negbin}(
  df,
  fit,
  alpha = 0.05,
  names = NULL,
  yhatName = "pred",
  nSims = 2000,
  ...
)
}
\arguments{
\item{df}{A data frame of new data.}

\item{fit}{An object of class \code{negbin}.}

\item{alpha}{A real number between 0 and 1. Controls the confidence
level of the interval estimates.}

\item{names}{\code{NULL} or character vector of length two. If
\code{NULL}, prediction bounds automatically will be named by
\code{add_pi}, otherwise, the lower prediction bound will be
named \code{names[1]} and the upper prediction bound will be
named \code{names[2]}.}

\item{yhatName}{A string. Name of the predictions vector.}

\item{nSims}{A positive integer. Determines the number of
simulations to run.}

\item{...}{Additional arguments.}
}
\value{
A dataframe, \code{df}, with predicted values, upper and lower
    prediction bounds attached.
}
\description{
This function is one of the methods for \code{add_pi}, and is
called automatically when \code{add_pi} is used on a \code{fit} of
class \code{negbin}.
}
\details{
Prediction intervals for negative binomial fits are formed through
a two part simulation scheme:

1. Model coefficients are generated through a parametric bootstrap
procedure that simulates the uncertainty in the regression
coefficients.

2. Random draws from the negative binomial
distribution are taken with a mean that varies based on the model
coefficients determined in step (1) and over-dispersion parameter
that is taken from the original fitted model.

Quantiles of the simulated responses are taken at the end to
produce intervals of the desired level.
}
\examples{
x1 <- rnorm(100, mean = 1)
y <- MASS::rnegbin(n = 100, mu = exp(1 + x1), theta = 5)
df <- data.frame(x1 = x1, y = y)
fit <- MASS::glm.nb(y ~ x1, data = df)
add_pi(df, fit, names = c("lpb", "upb"))

}
\seealso{
\code{\link{add_ci.negbin}} for confidence intervals for
    \code{negbin} objects, \code{\link{add_probs.negbin}} for conditional
    probabilities of \code{negbin} objects, and
    \code{\link{add_quantile.negbin}} for response quantiles of
    \code{negbin} objects.
}
