% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pi_glmer.R
\name{add_pi.glmerMod}
\alias{add_pi.glmerMod}
\title{Prediction Intervals for Generalized Linear Mixed Model Predictions}
\usage{
\method{add_pi}{glmerMod}(
  tb,
  fit,
  alpha = 0.05,
  names = NULL,
  yhatName = "pred",
  type = "boot",
  includeRanef = TRUE,
  nSims = 10000,
  ...
)
}
\arguments{
\item{tb}{A tibble or data frame of new data.}

\item{fit}{An object of class \code{glmerMod}.}

\item{alpha}{A real number between 0 and 1. Controls the confidence
level of the interval estimates.}

\item{names}{\code{NULL} or character vector of length two. If
\code{NULL}, prediction bounds automatically will be named by
\code{add_pi}, otherwise, the lower prediction bound will be
named \code{names[1]} and the upper prediction bound will be
named \code{names[2]}.}

\item{yhatName}{\code{NULL} or a string. The name of the
predictions vector.}

\item{type}{A string. Must be \code{"boot"}, If \code{type =
"boot"}, then \code{add_ci} calls \code{lme4::bootMer} to
calculate the confidence intervals.}

\item{includeRanef}{A logical. Default is \code{TRUE}. Set whether
the predictions and intervals should be made conditional on the
random effects. If \code{FALSE}, random effects will not be
included.}

\item{nSims}{A positive integer.  Controls the number of bootstrap
replicates.}

\item{...}{Additional arguments.}
}
\value{
A tibble, \code{tb}, with predicted values, upper and lower
    prediction bounds attached.
}
\description{
This function is one of the methods for \code{add_pi}, and is
called automatically when \code{add_pi} is used on a \code{fit} of
class \code{glmerMod}.
}
\details{
Prediction intervals are approximate and determined by simulation
through the \code{simulate} function distributed with \code{lme4}.
}
\examples{
n <- 300
x <- runif(n)
f <- factor(sample(1:5, size = n, replace = TRUE))
y <- rpois(n, lambda = exp(1 - 0.05 * x * as.numeric(f) + 2 * as.numeric(f)))
tb <- tibble::tibble(x = x, f = f, y = y)
fit <- lme4::glmer(y ~ (1+x|f), data=tb, family = "poisson")

add_pi(tb, fit, names = c("LPB", "UPB"), nSims = 500)

}
\seealso{
\code{\link{add_ci.glmerMod}} for confidence intervals
    of \code{glmerMod} objects, \code{\link{add_probs.glmerMod}} for
    conditional probabilities of \code{glmerMod} objects, and
    \code{\link{add_quantile.glmerMod}} for response quantiles of
    \code{glmerMod} objects.
}
