% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pi_glm.R
\name{add_pi.glm}
\alias{add_pi.glm}
\title{Prediction Intervals for Generalized Linear Models}
\usage{
\method{add_pi}{glm}(tb, fit, alpha = 0.05, names = NULL,
  yhatName = "pred", nSims = 1000, type = "sim", ...)
}
\arguments{
\item{tb}{A tibble or data frame of new data.}

\item{fit}{An object of class \code{glm}.}

\item{alpha}{A real number between 0 and 1. Controls the confidence
level of the interval estimates.}

\item{names}{\code{NULL} or character vector of length two. If
\code{NULL}, prediction bounds automatically will be named by
\code{add_pi}, otherwise, the lower prediction bound will be
named \code{names[1]} and the upper prediction bound will be
named \code{names[2]}.}

\item{yhatName}{A string. Name of the predictions vector.}

\item{nSims}{A positive integer. Determines the number of
simulations to run.}

\item{type}{A string. Currently \code{type = "sim"} is the only
valid string.}

\item{...}{Additional arguments.}
}
\value{
A tibble, \code{tb}, with predicted values, upper and lower
    prediction bounds attached.
}
\description{
This function is one of the methods for \code{add_pi}, and is
called automatically when \code{add_pi} is used on a \code{fit} of
class \code{glm}.
}
\details{
Prediction intervals are generated through simulation via
\code{arm::sim}. At the moment, only prediction intervals for
Poisson GLMs with the log link function are supported. Note that if
the response is count data, prediction intervals are only
approximate.
}
\examples{
# Fit a Poisson model
fit <- glm(dist ~ speed, data = cars, family = "poisson")
# Add prediction intervals and fitted values to the original data frame
add_pi(cars, fit)
# Try a different confidence level
add_pi(cars, fit, alpha = 0.5)
# Try custom names for the prediction bounds (may be useful for plotting)
add_pi(cars, fit, alpha = 0.5, names = c("lwr", "upr"))

}
\seealso{
\code{\link{add_ci.glm}} for confidence intervals for
    \code{glm} objects, \code{\link{add_probs.glm}} for conditional
    probabilities of \code{glm} objects, and
    \code{\link{add_quantile.glm}} for response quantiles of
    \code{glm} objects.
}
