% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chrome.R
\name{Chrome}
\alias{Chrome}
\title{Local Chrome process}
\description{
Local Chrome process

Local Chrome process
}
\details{
This is a subclass of \code{\link{Browser}} that represents a local browser. It extends
the \code{\link{Browser}} class with a \code{\link[processx:process]{processx::process}} object, which represents
the browser's system process.
}
\seealso{
\code{\link[=get_chrome_args]{get_chrome_args()}}
}
\section{Super class}{
\code{\link[chromote:Browser]{chromote::Browser}} -> \code{Chrome}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Chrome$new()}}
\item \href{#method-get_path}{\code{Chrome$get_path()}}
\item \href{#method-clone}{\code{Chrome$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="chromote" data-topic="Browser" data-id="close">}\href{../../chromote/html/Browser.html#method-close}{\code{chromote::Browser$close()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="chromote" data-topic="Browser" data-id="get_host">}\href{../../chromote/html/Browser.html#method-get_host}{\code{chromote::Browser$get_host()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="chromote" data-topic="Browser" data-id="get_port">}\href{../../chromote/html/Browser.html#method-get_port}{\code{chromote::Browser$get_port()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="chromote" data-topic="Browser" data-id="get_process">}\href{../../chromote/html/Browser.html#method-get_process}{\code{chromote::Browser$get_process()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="chromote" data-topic="Browser" data-id="is_local">}\href{../../chromote/html/Browser.html#method-is_local}{\code{chromote::Browser$is_local()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new Chrome object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chrome$new(path = find_chrome(), args = get_chrome_args())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Location of chrome installation}

\item{\code{args}}{A character vector of command-line arguments passed when
initializing Chrome. Single on-off arguments are passed as single
values (e.g.\code{"--disable-gpu"}), arguments with a value are given with a
nested character vector (e.g. \code{c("--force-color-profile", "srgb")}).
See
\href{https://peter.sh/experiments/chromium-command-line-switches/}{here}
for a list of possible arguments. Defaults to \code{\link[=get_chrome_args]{get_chrome_args()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Chrome} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_path"></a>}}
\if{latex}{\out{\hypertarget{method-get_path}{}}}
\subsection{Method \code{get_path()}}{
Browser application path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chrome$get_path()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chrome$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
