% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmastreeshape.R
\name{xmastreeshape}
\alias{xmastreeshape}
\title{Christmas shaped tree.}
\usage{
xmastreeshape(
  year = 2018,
  language = c("english", "spanish", "catalan"),
  shape = c("piramidal", "oval", "vshaped", "round", "columnar"),
  nballs = 15,
  ballscolor = NULL,
  seed = NULL
)
}
\arguments{
\item{year}{Year to be printed. Default is \code{2018}.}

\item{language}{Language to be used in the card. One of \code{c("english",
"spanish", "catalan")}. Default is \code{"english"}.}

\item{shape}{The shape of the tree. One of \code{c("piramidal", "oval",
"vshaped", "round", "columnar")}. Default is \code{"piramidal"}.}

\item{nballs}{The number of balls in the tree. Default is 15.}

\item{ballscolor}{The colors to be used for the balls in the tree. It must be
a vector with names of colors included in \code{colors()}, or \code{NULL}
(default). If \code{NULL}, then colors are randomly selected.}

\item{seed}{Seed for reproducibility of the card. Default is \code{NULL} (no
seed).}
}
\value{
A Christmas card plot including a christmas tree.
}
\description{
Christmas trees (2017 card) with different shapes.
}
\examples{
\donttest{
xmastreeshape()
xmastreeshape(shape = "oval", language = "catalan", ballscolor = "blue")
xmastreeshape(shape = "vshaped", nballs = 15, ballscolor = c("sienna2", "yellow2", "tomato"),
              seed = 1111)
xmastreeshape(shape = "round", language = "spanish")
xmastreeshape(shape = "columnar", nballs = 20, ballscolor = "red")
}
}
\author{
Jose Barrera-Gomez.
}
