% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_chords.R
\name{get_chords}
\alias{get_chords}
\title{get_chords}
\usage{
get_chords(song_url, nf = FALSE)
}
\arguments{
\item{song_url}{The song URLs to be used for the chords collection. 
Can be either a character vector or straightforwardly the result of the 
`get_songs()` function.}

\item{nf}{logical. If the chords of a song are not found,
should we return this information in the final result?}
}
\value{
An object of type `tibble` with the chords sequences, key, song names and name of the artist.
}
\description{
Extracts music chords from an artist.
}
\examples{
{
\donttest{
  songs <- get_songs("tim-maia")
  get_chords(songs$url[2])
}
}
}
