% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridding.R
\name{par_split_list}
\alias{par_split_list}
\title{Split grid list to a nested list of row-wise data frames}
\usage{
par_split_list(gridlist)
}
\arguments{
\item{gridlist}{list. Output of \code{\link{par_pad_grid}} or \code{\link{par_pad_balanced}}}
}
\value{
A nested list of data frames or WKT strings.
}
\description{
Split grid list to a nested list of row-wise data frames
}
\details{
If the input is a data frame, the function will return a list of
two data frames: \code{original} and \code{padded}. If the input is a WKT vector,
the function will return a list of two WKT strings: \code{original} and \code{padded}.
}
\examples{
lastpar <- par(mfrow = c(1, 1))

library(sf)
library(terra)
options(sf_use_s2 = FALSE)

ncpath <- system.file("shape/nc.shp", package = "sf")
nc <- read_sf(ncpath)
nc <- st_transform(nc, "EPSG:5070")
nc_comp_region <-
  par_pad_grid(
    nc,
    mode = "grid",
    nx = 4L, ny = 2L,
    padding = 10000)
par_split_list(nc_comp_region)

par(lastpar)
}
\seealso{
Other Parallelization: 
\code{\link{par_cut_coords}()},
\code{\link{par_grid}()},
\code{\link{par_grid_mirai}()},
\code{\link{par_hierarchy}()},
\code{\link{par_hierarchy_mirai}()},
\code{\link{par_make_grid}()},
\code{\link{par_merge_grid}()},
\code{\link{par_multirasters}()},
\code{\link{par_multirasters_mirai}()},
\code{\link{par_pad_balanced}()},
\code{\link{par_pad_grid}()}
}
\concept{Parallelization}
