% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addEuclideanPath.R
\name{addEuclideanPath}
\alias{addEuclideanPath}
\title{Add the path for the Euclidean distance between cases and/or pumps.}
\usage{
addEuclideanPath(origin, destination = NULL, type = "case-pump",
  observed = TRUE, case.location = "address", vestry = FALSE,
  distance.unit = "meter", time.unit = "second", walking.speed = 5,
  unit.posts = "distance", unit.interval = NULL, alpha.level = 1)
}
\arguments{
\item{origin}{Numeric or Integer. Numeric ID of case or pump.}

\item{destination}{Numeric or Integer. Numeric ID(s) of case(s) or pump(s). Exclusion is possible via negative selection (e.g., -7). Default is \code{NULL}: this returns closest pump or "anchor" case.}

\item{type}{Character "case-pump", "cases" or "pumps".}

\item{observed}{Logical. Use observed or simulated expected data.}

\item{case.location}{Character. For \code{observed = FALSE}: "address" or "nominal". "address" is the x-y coordinate of a stack's "anchor" case. "nominal" is the x-y coordinate of a bar.}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry Report. \code{FALSE} uses the 13 pumps from the original map.}

\item{distance.unit}{Character. Unit of distance: "meter", "yard" or "native". "native" returns the map's native scale. See \code{vignette("roads")} for information on unit distances.}

\item{time.unit}{Character. "hour", "minute", or "second".}

\item{walking.speed}{Numeric. Walking speed in km/hr.}

\item{unit.posts}{Character. "distance" for mileposts; "time" for timeposts; \code{NULL} for no posts.}

\item{unit.interval}{Numeric. Sets interval between \code{unit.posts}.}

\item{alpha.level}{Numeric. Alpha level transparency for path: a value in [0, 1].}
}
\value{
An R list with 3 data frames: x-y coordinates for the origin and destination, and a summary of results.
}
\description{
Add the path for the Euclidean distance between cases and/or pumps.
}
\note{
Walking time is computed using \code{distanceTime()}.
}
