% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streetNumberLocator.R
\name{streetNumberLocator}
\alias{streetNumberLocator}
\title{Locate road by numerical ID.}
\usage{
streetNumberLocator(road.number, zoom = FALSE, radius = 1,
  cases = "anchors", add.title = TRUE, add.pump = TRUE,
  vestry = FALSE, highlight = TRUE, unit = "meter",
  time.unit = "second", walking.speed = 5)
}
\arguments{
\item{road.number}{Numeric or integer. A whole number between 1 and 528.}

\item{zoom}{Logical.}

\item{radius}{Numeric. Controls the degree of zoom.}

\item{cases}{Character. Plot cases: \code{NULL}, "anchors" or "all".}

\item{add.title}{Logical. Include title.}

\item{add.pump}{Logical. Include nearby pumps.}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry report. \code{FALSE} uses the 13 in the original map.}

\item{highlight}{Logical. Highlight selected road.}

\item{unit}{Character. Unit of measurement: "meter" or "yard". Default is \code{NULL}, which returns the map's native scale.}

\item{time.unit}{Character. "hour", "minute", or "second".}

\item{walking.speed}{Numeric. Walking speed in km/hr.}
}
\value{
A base R graphics plot.
}
\description{
Highlight a road and its cases. See \code{cholera::roads} for numerical IDs and \code{vignette}("road.names") for details.
}
\examples{
streetNumberLocator(243)
streetNumberLocator(243, zoom = TRUE)
streetNumberLocator(243, zoom = TRUE, radius = 0)
}
\seealso{
\code{\link{roads}}, \code{\link{road.segments}}, \code{\link{streetNameLocator}}, \code{vignette("roads")}
}
