% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCases.R
\name{addCases}
\alias{addCases}
\title{Add observed cases by walking neighborhood.}
\usage{
addCases(pump.subset = NULL, pump.select = NULL, type = "address",
  token = "id", text.size = 0.5, vestry = FALSE, weighted = TRUE,
  color = NULL, multi.core = FALSE, ...)
}
\arguments{
\item{pump.subset}{Numeric. Vector of numeric pump IDs to select (subset) from the neighborhoods defined by "pump.select". Negative selection possible. NULL selects all pumps in "pump.select".}

\item{pump.select}{Numeric. Vector of numeric pump IDs to define pump neighborhoods (i.e., the "population"). Negative selection possible. NULL selects all pumps.}

\item{type}{Character. Type of case: "address" (base of stack) or "fatalities" (entire stack).}

\item{token}{Character. Type of token to plot: "point" or "id".}

\item{text.size}{Numeric. Size of case ID text.}

\item{vestry}{Logical. TRUE uses the 14 pumps from the Vestry Report. FALSE uses the 13 in the original map.}

\item{weighted}{Logical. TRUE computes shortest path weighted by road length. FALSE computes shortest path in terms of the number of nodes.}

\item{color}{Character. Use a single color for all paths. NULL uses neighborhood colors defined by snowColors().}

\item{multi.core}{Logical or Numeric. TRUE uses parallel::detectCores(). FALSE uses one, single core. You can also specify the number logical cores. On Window, only "multi.core = FALSE" is available.}

\item{...}{Additional plotting parameters.}
}
\description{
Add cases, as "address" or "fatalities" as points or IDs, to a plot.
}
\examples{
\dontrun{
snowMap()
addCases(pump.susbet = c(6, 10))

snowMap()
addCases(pump.select = c(6, 10))
}
}
