% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addNeighborhood.R
\name{addNeighborhood}
\alias{addNeighborhood}
\title{Add expected neighborhood polygons}
\usage{
addNeighborhood(pump.subset = NULL, pump.select = NULL, vestry = FALSE,
  weighted = TRUE, multi.core = FALSE, type = "area", color = NULL,
  alpha.level = 0.125, ...)
}
\arguments{
\item{pump.subset}{Numeric. Vector of pumps to select (subset) from neighborhoods defined by "pump.select". Negative selection possible. NULL selects all pumps in "pump.select".}

\item{pump.select}{Numeric. Numeric vector of pumps to define pump neighborhoods (i.e. the "population"). Negative selection possible. NULL selects all pumps.}

\item{vestry}{Logical. TRUE uses the 14 pumps from the Vestry Report. FALSE uses the 13 in the original map.}

\item{weighted}{Logical. TRUE computes shortest path weighted by road length. FALSE computes shortest path in terms of the number of nodes.}

\item{multi.core}{Logical or Numeric. TRUE uses parallel::detectCores(). FALSE uses one, single core. You can also specify the number logical cores. On Window, only "multi.core = FALSE" is available.}

\item{type}{Character. Type of annotation plot: "area", "border" or "street".}

\item{color}{Character. Neighborhood color.}

\item{alpha.level}{Numeric. Alpha level transparency: a value in [0, 1].}

\item{...}{Additional plotting parameters.}
}
\description{
In-development prototype.
}
\section{Note}{
 This function is computationally intensive. On a single core of a 2.3 GHz Intel i7, plotting observed paths to PDF takes about 30 seconds. Using the parallel implementation on 4 physical (8 logical) cores, this time falls to about 12 seconds. Note that parallelization is currently only available on Linux and Mac, and that although some precautions are taken in R.app on macOS, the developers of the 'parallel' package, which neighborhoodWalking() uses, strongly discourage against using parallelization within a GUI or embedded environment. See vignette("parallel") for details.
}

\examples{
# streetNameLocator("marshall street", zoom = TRUE, highlight = FALSE,
#   unit = "meter", cases = NULL)
# addNeighborhood(6:7)
}
\seealso{
\code{\link{snowMap}},
\code{\link{addIndexCase}},
\code{\link{addKernelDensity}},
\code{\link{addLandmarks}},
\code{\link{addPlaguePit}},
\code{\link{addVoronoi}},
\code{\link{addWhitehead}}
}
