% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streetNumberLocator.R
\name{streetNumberLocator}
\alias{streetNumberLocator}
\title{Locate road by numerical ID.}
\usage{
streetNumberLocator(road.number, zoom = FALSE, radius = 1,
  cases = "anchors", unit = NULL)
}
\arguments{
\item{road.number}{Numeric or integer. A whole number between 1 and 528.}

\item{zoom}{Logical.}

\item{radius}{Numeric. Controls the degree of zoom.}

\item{cases}{Character. Plot cases: NULL, "anchors" or "all".}

\item{unit}{Character. Unit of measurement: "meter" or "yard". Default is NULL, which returns the map's native scale.}
}
\value{
A base R graphics plot.
}
\description{
Highlight a road and its cases. See cholera::roads for numerical IDs and \code{vignette}("road.names") for details.
}
\examples{
streetNumberLocator(243)
streetNumberLocator(243, zoom = TRUE)
streetNumberLocator(243, zoom = TRUE, radius = 0)
}
\seealso{
\code{\link{roads}}, \code{\link{road.segments}}, \code{\link{streetNameLocator}}, \code{vignette("road.names")}
}
