% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-lt.R
\name{chk_lt}
\alias{chk_lt}
\alias{vld_lt}
\title{Check Less Than}
\usage{
chk_lt(x, value = 0, x_name = NULL)

vld_lt(x, value = 0)
}
\arguments{
\item{x}{The object to check.}

\item{value}{A non-missing scalar of a value.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if all non-missing values are less than value using

\code{all(x[!is.na(x)] < value)}
}
\section{Functions}{
\itemize{
\item \code{vld_lt()}: Validate Less Than

}}
\examples{
# chk_lt
chk_lt(-0.1)
try(chk_lt(c(-0.1, 0.2)))
# vld_lt
vld_lt(numeric(0))
vld_lt(0)
vld_lt(-0.1)
vld_lt(c(-0.1, -0.2, NA))
vld_lt(c(-0.1, 0.2))
vld_lt(c(-0.1, 0.2), value = 1)
vld_lt("a", value = "b")
}
\seealso{
Other chk_ranges: 
\code{\link{chk_gt}()},
\code{\link{chk_gte}()},
\code{\link{chk_lte}()},
\code{\link{chk_range}()}
}
\concept{chk_ranges}
