% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-list.R
\name{chk_list}
\alias{chk_list}
\alias{vld_list}
\title{Check List}
\usage{
chk_list(x, x_name = NULL)

vld_list(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if is a list using

\code{is.list(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_list()}: Validate List

}}
\examples{
# chk_list
chk_list(list())
try(chk_list(1))
# vld_list
vld_list(list())
vld_list(list(x = 1))
vld_list(mtcars)
vld_list(1)
vld_list(NULL)
}
\seealso{
Other chk_typeof: 
\code{\link{chk_character}()},
\code{\link{chk_character_or_factor}()},
\code{\link{chk_count}()},
\code{\link{chk_double}()},
\code{\link{chk_environment}()},
\code{\link{chk_factor}()},
\code{\link{chk_integer}()},
\code{\link{chk_logical}()}
}
\concept{chk_typeof}
