% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-character.R
\name{chk_character}
\alias{chk_character}
\alias{vld_character}
\title{Check Character}
\usage{
chk_character(x, x_name = NULL)

vld_character(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if character using

\code{is.character(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_character}: Validate Character
}}

\examples{
# chk_character
chk_character("1")
try(chk_character(1))
# vld_character
vld_character("1")
vld_character(matrix("a"))
vld_character(character(0))
vld_character(NA_character_)
vld_character(1)
vld_character(TRUE)
vld_character(factor("text"))
}
\seealso{
Other chk_typeof: 
\code{\link{chk_double}()},
\code{\link{chk_environment}()},
\code{\link{chk_integer}()},
\code{\link{chk_list}()},
\code{\link{chk_logical}()}
}
\concept{chk_typeof}
