% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_left.R
\name{sparse_left}
\alias{sparse_left}
\title{Check How many Words are Left under Certain Sparse Values}
\usage{
sparse_left(x, sparse)
}
\arguments{
\item{x}{a DocumentTermMatrix or TermDocumentMatrix object.}

\item{sparse}{a numeric vector with elements >= 0 and <= 1.}
}
\description{
This function does not really remove sparse words (which is what 
\code{tm::removeSparseTerms} does); rather, it only shows how 
many words are left when you specify some sparse values. 
See Examples.
}
\examples{
x <- c(
  "Hello, what do you want to drink?", 
  "drink a bottle of milk", 
  "drink a cup of coffee", 
  "drink some water")
dtm <- corp_or_dtm(x, from = "v", type = "dtm")
y <- sparse_left(dtm, seq(0, 1, 0.1))
# Then you can use plot(sort(y, decreasing = TRUE), type = "b") to 
# see which sparse value is proper.
}
