% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_cmip6_ecmwfr.R
\name{download_cmip6_ecmwfr}
\alias{download_cmip6_ecmwfr}
\title{Download CMIP6 Data via the ecwfr package}
\usage{
download_cmip6_ecmwfr(
  scenarios,
  area,
  user,
  key,
  model = "default",
  service = "cds",
  frequency = "monthly",
  variable = c("Tmin", "Tmax"),
  year_start = 2015,
  year_end = 2100,
  month = 1:12,
  sec_wait = 3600,
  n_try = 10,
  update_everything = FALSE,
  path_download = "cmip6_downloaded"
)
}
\arguments{
\item{scenarios}{vector of characters specifying the shared socioeconomic
pathway scenarios (SSP) to be downloaded. Currently the values 'ssp126',
'ssp245', 'ssp370' and 'ssp585' are the only accepted options. These are the
standard scenarios of CMIP6.}

\item{area}{numeric vector of length 4. Sets the spatial boundaries of the
downloaded data. Coordinates are supplied in the following format: 
c(maximum latitude, minimum longitude, minimum latitude, maximum longitude),
which corresponds to the northern extent, western extent, southern extent
and eastern extent of the area of interest.}

\item{user}{a character, user name from the Copernicus climate data store.
See 'Details' for more information.}

\item{key}{a character. Can be found just beneath the user id on the profile
when registering for the Copernicus website. Should be provided as a
character (so in quotation marks).}

\item{model}{character, by default "default". Decides which global climate
models are requested. If set to "default" then depending on the scenario and
temporal resolution around 20 models are selected for which we know that
certain combinations of scenario and variables are available. If this is set
to "all", then all potential models are requested. You can also hand-pick the
models you want to download as a vector of the model names.
You can check \url{https://cds.climate.copernicus.eu/cdsapp#!/dataset/projections-cmip6?tab=form}
for the list of models. In case a certain request fails because either the
model name is wrong or the requested combination of SSP, time period and
variable is not available, then the model is dropped from the requests and
the function carries on with the remaining requests. The user will get a
warning in these cases.}

\item{service}{character, by default 'cds'. Decides which database is used.
For more details see in the documentation of
\code{\link[ecmwfr:wf_set_key]{ecmwfr::wf_set_key()}}.}

\item{frequency}{character, can be either 'daily' or 'monthly'. Sets
if the downloaded CMIP6 data is in daily or monthly format.}

\item{variable}{vector of characters, decides which variables get downloaded. 
Currently, the options "Tmin" (Daily minimum temperature in degree centigrade), 
"Tmax" (Daily maximum temperature in degree centigrade) 
and "Prec" (Daily sum of precipitation in mm) are the only valid options.}

\item{year_start}{numeric, earliest year for downloaded CMIP6 data. By default set
to 2015.}

\item{year_end}{numeric, latest year for downloaded CMIP6 data. By default set
to 2100.}

\item{month}{numeric vector, sets for which months data should be downloaded.
By default set to 1:12.}

\item{sec_wait}{numeric, sets the maximum waiting time per requested file.
By default is 3600, so 1 hour.}

\item{n_try}{numeric, number of repeated calls for the API. For more
information see 'Details'.}

\item{update_everything}{logical, by default set to FALSE. When set to FALSE,
scenarios with matching names that have already been downloaded are skipped.
If set to TRUE, then files are downloaded regardless if a file with the same
name is already present.}

\item{path_download}{character, sets the path for the download of the CMIP6
file. If not already present, then a new folder will be created. 
The path is relative to the working directory.}
}
\value{
NULL, the downloaded files are saved in the stated directory
}
\description{
Accesses the CMIP6 data of the Coperincus API via the
\code{\link[ecmwfr:wf_request_batch]{ecmwfr}} package. Saves the downloaded
files as .zip objects in the specified path in a subfolder with the
coordinates of the downloaded area as subfolder name. You can either specify
the GCMs by name, take the combinations of scenario and GCM that worked in
the past (model = 'default') or you can try out all GCMs for a scenario and
take the ones for which there is data (model = 'all').
}
\details{
Registering for cds.climate.coperincus.eu:
\url{https://cds.climate.copernicus.eu/cdsapp#!/home}

Finding the user id and the key:

On the website of the Copernicus climate data store, navigate to the user
profile and scroll to the bottom to "API key". There you can find the item
"UID". The user id should be provided as character (within quotation marks).
Just below, you can also find the key, which is also needed when using this
function.

After successful registration some extra steps are needed in order to be
able to download CMIP6 data. In addition to the "Terms of use of the
Copernicus Climate Store" and the "Data Protection and Privacy Agreement",
you also need to agree to the "CMIP6 - Data Access - Terms of Use". 
This needs to be done after registering. You can agree to the terms via the
following link:
\url{https://cds.climate.copernicus.eu/cdsapp/#!/terms/cmip6-wps}. 

Alternatively, you can navigate to the terms within the Copernicus webpage.
Go to "Datasets", you can find it in the upper ribbon of the main page. 
There you need to search for "CMIP6" using the search field
and choose the first result, which is named "CMIP6 climate projections". 
There you need to click on "Download data" and scroll to the very bottom of
the page to the field "Terms of Use". There you need to click on the button
saying "Accept Terms". If you do not accept the terms the download via the
API (and consequently via this function) will not be possible!


Sometimes the server is not responding in time, which can make the download
fail. In such cases, after a short waiting time of 5 seconds, the request is
started again. If the error reoccurs several times, the requested model
will be dropped from the list of requests. By default the number of allowed
repeated requests is 10. The user will get a warning if the model is dropped
from the requests.
}
\examples{
\dontrun{
# example with one specified GCM 
download_cmip6_ecmwfr(
    scenarios = 'ssp126', 
    area = c(55, 5.5, 47, 15.1),
    user = 'write user id here'
    key = 'write key here',
    model = 'AWI-CM-1-1-MR',
    frequency = 'monthly', 
    variable = c('Tmin', 'Tmax'),
    year_start = 2015, 
    year_end = 2100)

# example with default combinations of scenario and GCM
download_cmip6_ecmwfr(
    scenarios = 'ssp126', 
    area = c(55, 5.5, 47, 15.1),
    user = 'write user id here'
    key = 'write key here',
    model = 'default',
    frequency = 'monthly', 
    variable = c('Tmin', 'Tmax'),
    year_start = 2015, 
    year_end = 2100)

# example with all possible combinations of scenario and GCM
# this may take a little longer
download_cmip6_ecmwfr(
    scenarios = 'ssp126', 
    area = c(55, 5.5, 47, 15.1),
    user = 'write user id here'
    key = 'write key here',
    model = 'all',
    frequency = 'monthly', 
    variable = c('Tmin', 'Tmax'),
    year_start = 2015, 
    year_end = 2100)
}
}
\author{
Lars Caspersen, Antonio Picornell
}
