% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_hourly_temps.R
\name{make_hourly_temps}
\alias{make_hourly_temps}
\title{Make hourly temperature record from daily data}
\usage{
make_hourly_temps(latitude, year_file, keep_sunrise_sunset = FALSE)
}
\arguments{
\item{latitude}{the geographic latitude (in decimal degrees) of the location
of interest}

\item{year_file}{a data frame containing data on daily minimum temperature
(called Tmin), daily maximum temperature (called Tmax), and date
information. Dates can either be specified by two columns called Year and
JDay, which contain the Year and Julian date (day of the year), or as three
columns called Year, Month and Day. year_file cannot have any missing
values, so it may be a good idea to process the relevant columns with
make_all_day_table and interpolate_gaps before.}

\item{keep_sunrise_sunset}{boolean variable indicating whether information
on sunrise, sunset and daylength, which is calculated for producing hourly
temperature records, should be preserved in the output. Defaults to FALSE.}
}
\value{
data frame containing all the columns of year_file, plus 24 columns
for hourly temperatures (called Hour_1 ... Hour_24).
}
\description{
This function generates hourly temperature records for a particular location
from daily minimum and maximum temperatures and latitude.
}
\details{
Temperature estimates are based on an idealized daily temperature curve that
uses a sine curve for daytime warming and a logarithmic decay function for
nighttime cooling. The input data frame can have more columns, which are
preserved, but ignored in the processing. References to papers outlining the
procedures are given below.

Note that this function should be able to generate hourly temperatures for
all latitudes, but it uses an algorithm designed for locations with regular
day/night behavior. It may therefore be that the curves aren't very realistic
for very short or very long days, or especially for polar days and nights.
}
\examples{

weather<-fix_weather(KA_weather)

THourly<-make_hourly_temps(50.4,weather$weather)

#in most cases, you're probably better served by stack_hour_temperatures

}
\references{
Luedeling E, Kunz A and Blanke M, 2013. Identification of
chilling and heat requirements of cherry trees - a statistical approach.
International Journal of Biometeorology 57,679-689.

Luedeling E, Girvetz EH, Semenov MA and Brown PH, 2011. Climate change
affects winter chill for temperate fruit and nut trees. PLoS ONE 6(5),
e20155.

The temperature interpolation is described in

Linvill DE, 1990. Calculating chilling hours and chill units from daily
maximum and minimum temperature observations. HortScience 25(1), 14-16.

Calculation of sunrise, sunset and daylength was done according to

Spencer JW, 1971. Fourier series representation of the position of the Sun.
Search 2(5), 172.

Almorox J, Hontoria C and Benito M, 2005. Statistical validation of
daylength definitions for estimation of global solar radiation in Toledo,
Spain. Energy Conversion and Management 46(9-10), 1465-1471)
}
\author{
Eike Luedeling
}
\keyword{utility}
