% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack_hourly_temps.R
\name{stack_hourly_temps}
\alias{stack_hourly_temps}
\title{Stacking of hourly temperatures}
\usage{
stack_hourly_temps(weather = NULL, latitude = 50, hour_file = NULL,
  keep_sunrise_sunset = FALSE)
}
\arguments{
\item{weather}{weather data frame containing either daily minimum ("Tmin")
and maximum ("Tmax") temperatures in the format generated by fix_weather, of
hourly temperatures in the format generated by make_hourly_temps (see below;
this can also be passed as hour_file).}

\item{latitude}{the geographic latitude (in decimal degrees) of the location
of interest}

\item{hour_file}{this is a data frame of hourly temperatures, as generated
by make_hourly_temps. It has columns describing the date (Year+JDay or
Year+Month+Day) and 24 columns called Hour_1 ... Hour_24 that contain hourly
temperatures. This is no longer required, since weather can be specified by
the weather argument. This parameter is only for compatibility with earlier
versions of chillR.}

\item{keep_sunrise_sunset}{boolean variable indicating whether information
on sunrise, sunset and daylength, which is calculated for producing hourly
temperature records, should be preserved in the output. Defaults to FALSE.}
}
\value{
list containing two elements: hourtemps: data frame containing all
the columns of the input data frame, except the hourly temperatures.
Instead, two columns are added: Hour is the hour of the day, and Temp is the
corresponding modeled mean temperature for that hour. QC: either the Quality
control attribute ("QC") passed into the function within the daily
temperature record produced by fix_weather, or NA.
}
\description{
This function processes hourly temperatures generated by make_hourly_temps
for calculation of chilling and forcing. The chilling function requires
temperatures to be in a long list, and this function prepares them in this
way.
}
\examples{


weather<-fix_weather(KA_weather[which(KA_weather$Year>2004),])

hourtemps<-stack_hourly_temps(weather, latitude=50.4)



}
\references{
Luedeling E, Kunz A and Blanke M, 2013. Identification of
chilling and heat requirements of cherry trees - a statistical approach.
International Journal of Biometeorology 57,679-689.
}
\author{
Eike Luedeling
}
\keyword{utility}
