% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdsvals.r
\name{sds_pub2d}
\alias{sds_pub2d}
\title{Calculate SDS Values}
\usage{
sds_pub2d(
  value,
  pubstat,
  x2,
  sex,
  item,
  ref,
  type = "SDS",
  male = "male",
  female = "female",
  age = NULL,
  id = 1:length(value)
)
}
\arguments{
\item{value}{vector of measurement values}

\item{pubstat}{vector of Tanner stages coded 1 to 5}

\item{x2}{2nd predictor (vector), e.g. bmisds must be contained in reference}

\item{sex}{vector of sex}

\item{item}{name of the item e.g. "height"}

\item{ref}{RefGroup object}

\item{type}{"SDS" or "perc"}

\item{male}{coding of sex for male}

\item{female}{coding of sex for female}

\item{age}{not used yet}

\item{id}{order of values}
}
\value{
vector containing SDS or percentile values
}
\description{
Calculate SDS values depending on the Tanner stage and a second variable
}
\details{
The function takes a vector of measurement values, and of tanner stage
of a second variable (x2) and of sex
and a RefGroup object as arguments. It calculates the sds or percentile
values.
}
\author{
Mandy Vogel
}
