#' LMS Parameters for the Centers for Disease Control and Prevention
#' 2000 Growth Charts, contains bmi, height, head cirumference, weight,
#' weight for length, 
#' @name cdc.ref
#' @docType data
#' @usage cdc.ref
#' @source National health statitics reports 63.
NULL

#' LMS Parameters for German reference data (KiGGS, 2003-2006)
#' for height, weight, bmi, hip, whr, whtr, bodyfat, skinfold sum, triceps
#' skinfold, subscapular skinfold, and waist circumference
#' @name kiggs.ref 
#' @docType data
#' @usage kiggs.ref
#' @source Referenzperzentile fuer anthropometrische Masszahlen und Blutdruck aus KiGGS 2003-2006, Robert Koch Institut, Germany
NULL


#' LMS Parameters for German reference data (Kromeyer Hauschild, 2001)
#' for height, weight, bmi, and waist circumference, including preterm
#' correction (Voigt)
#' @name kro.ref
#' @docType data
#' @usage kro.ref
#' @source Perzentile fuer den Body-mass-Index fuer das Kindes- und Jugendalter unter Heranziehung verschiedener deutscher Stichproben, Monatsschrift Kinderheilkunde August 2001, Volume 149, Issue 8, pp 807-818; Fruehgeborenenkorrektur nach Voigt
NULL

#' LMS Parameters for UK-WHO growth charts for height,
#' weight, bmi, head circumference
#' @name ukwho.ref
#' @docType data
#' @usage ukwho.ref
#' @source Wright, Charlotte M., et a,Practice pointer: Using the new UK-WHO growth charts. British Medical Journal 340.c1140 (2010): 647-650.Preterm British 1990, 0-4 WHO2006, 4-18 British1990
NULL


#' LMS Parameters for UK-WHO growth charts for height, weight, bmi,
#' head circumference,arm mid upper arm circumference, subscapular
#' and triceps skinfold, weight for height
#' @name who.ref
#' @docType data
#' @usage who.ref
#' @source de Onis, M., Onyango, A., Borghi, E., Siyam, A., Blossner, M., & Lutter, C. (2012). Worldwide implementation of the WHO child growth standards. Public Health Nutr, 12, 1-8.
NULL


#' Parameters for iron-related blood parameters in children
#' @name iron.ref
#' @docType data
#' @usage iron.ref
#' @source Rieger, K. et al. Reference intervals for iron-related blood parameters: results from a population-based cohort study (LIFE Child). LaboratoriumsMedizin 40, (2016).
NULL


#' Parameters for serum lipids in children
#' @name lipids.ref
#' @docType data
#' @usage lipids.ref
#' @source Dathan-Stumpf, A. et al. Pediatric reference data of serum lipids and prevalence of dyslipidemia: Results from a population-based cohort in Germany. Clinical Biochemistry 49, 740--749 (2016).
NULL

#' Parameters derived from Turkish children
#' @name turkish.ref
#' @docType data
#' @usage turkish.ref
#' @source Hatipoglu, N. et al. Waist circumference percentiles for 7- to 17-year-old Turkish children and adolescents. Eur J Pediatr 167, 383--389 (2008);Bundak, R. et al. Body mass index references for Turkish children. Acta Paediatrica 95, 194--198 (2006).
#' @source Neyzi, O., Furman, A., Bundak, R., Gunoz, H., Darendeliler, F., Bas, F., 2006. Growth references for Turkish children aged 6 to 18 years. Acta Paediatrica 95, 1635-1641. doi:10.1080/08035250600652013
#' @source Bundak, R. et al. Body mass index references for Turkish children. Acta Paediatrica 95, 194-198 (2006).
NULL


#' Parameters derived from Japanese children
#' @name japanese.ref
#' @docType data
#' @usage japanese.ref
#' @source Inokuchi, M., Matsuo, N., Anzo, M., Takayama, J. I. & Hasegawa, T. Age-dependent percentile for waist circumference for Japanese children based on the 1992--1994 cross-sectional national survey data. Eur J Pediatr 166, 655--661 (2007)
NULL


#' Parameters derived from US children (additional to the cdc.ref)
#' @name us.ref
#' @docType data
#' @usage us.ref
#' @source Sharma, A. K., Metzger, D. L., Daymont, C., Hadjiyannakis, S. & Rodd, C. J. LMS tables for waist-circumference and waist-height ratio Z-scores in children aged 5-19 y in NHANES III: association with cardio-metabolic risks. Pediatric research (2015)
NULL


#' Parameters derived from Saudi children
#' @name saudi.ref
#' @docType data
#' @usage saudi.ref
#' @source Mouzan, M. I. E., Salloum, A. A. A., Alqurashi, M. M., Herbish, A. S. A. & Omar, A. A. The LMS and Z scale growth reference for Saudi school-age children and adolescents. Saudi Journal of Gastroenterology 22, 331 (2016)
#' @source Shaik, S.A., El Mouzan, M.I., AlSalloum, A.A., AlHerbish, A.S., 2016. Growth reference for Saudi preschool children: LMS parameters and percentiles. Ann Saudi Med 36, 2-6. doi:10.5144/0256-4947.2016.2
NULL


#' Parameters derived Ethiopian children
#' @name ethiop.ref
#' @docType data
#' @usage ethiop.ref
#' @source Amare, E. B. et al. Reference Ranges for Head Circumference in Ethiopian Children 0--2 Years of Age. World Neurosurgery 84, 1566--1571.e2 (2015).
NULL


#' Parameters derived from Portuguese children
#' @name portug.ref
#' @docType data
#' @usage portug.ref
#' @source Chaves, R., Baxter-Jones, A., Souza, M., Santos, D. & Maia, J. Height, weight, body composition, and waist circumference references for 7-to 17-year-old children from rural Portugal. HOMO-Journal of Comparative Human Biology 66, 264--277 (2015).
NULL


#' Parameters derived from Italian children
#' @name italian.ref
#' @docType data
#' @usage italian.ref
#' @source Cacciari E, Milani S, Balsamo A, Spada E, Bona G, Cavallo L, et al. Italian cross-sectional growth charts for height, weight and BMI (2 to 20 yr). J Endocrinol Invest. 2006 Jul 1;29(7):581--93.
NULL

#' Parameters derived from the 4th Dutch growth study
#' @name nl4.ref
#' @docType data
#' @usage nl4.ref
#' @source Fredriks, A. M. et al. Nationwide age references for sitting height, leg length, and sitting height/height ratio, and their diagnostic value for disproportionate growth disorders. Archives of Disease in Childhood 90, 807--812 (2005);
#' Fredriks, A. M. et al. Height, weight, body mass index and pubertal development references for children of Moroccan origin in The Netherlands. Acta Paediatr. 93, 817--824 (2004);
#' Fredriks, A. M. et al. Continuing positive secular growth change in The Netherlands 1955--1997. Pediatric research 47, 316--323 (2000);
#' Fredriks, A. M. et al. Height, weight, body mass index and pubertal development reference values for children of Turkish origin in the Netherlands. Eur. J. Pediatr. 162, 788--793 (2003); Fredriks, A. M., van Buuren, S., Wit, J. M. & Verloove-Vanhorick, S. P. Body index measurements in 1996--7 compared with 1980. Archives of disease in childhood 82, 107--112 (2000);
#' R package: AGD, Stef van Buuren, http://www.stefvanbuuren.nl/
NULL

#' Parameters derived from Dutch children (additional to nl4.ref)
#' @name fredriks05.ref
#' @docType data
#' @usage fredriks05.ref
#' @source Fredriks, A. M. et al. Nationwide age references for sitting height, leg length, and sitting height/height ratio, and their diagnostic value for disproportionate growth disorders. Archives of Disease in Childhood 90, 807--812 (2005)
NULL

#' Parameters derived from Chinese children (additional to nl4.ref)
#' @name zong13.ref
#' @docType data
#' @usage zong13.ref
#' @source Zong, X.-N., Li, H. Construction of a New Growth References for China Based on Urban Chinese Children: Comparison with the WHO Growth Standards. PLOS ONE 8, e59569 (2013).
NULL


#' Parameters derived from the German KiGGS cohort
#' @name kiggs_bp.ref
#' @docType data
#' @usage kiggs_bp.ref
#' @details contains 2-dimensional reference grid. Do not use with \code{\link{sds}} but \code{\link{sds_2d}}
#' @source Neuhauser, H. K., Thamm, M., Ellert, U., Hense, H. W. & Rosario, A. S. Blood Pressure Percentiles by Age and Height from Nonoverweight Children and Adolescents in Germany. Pediatrics peds.2010-1290 (2011). doi:10.1542/peds.2010-1290.
NULL

#' Parameters derived from Flandern population
#' @name belgium.ref
#' @docType data
#' @usage belgium.ref
#' @source Roelants M, Hauspie R, Hoppenbrouwers K. References for growth and pubertal development from birth to 21 years in Flanders, Belgium. Annals of Human Biology. 2009 Dezember;36(6):680-94.
NULL


#' Parameters of skinfold measures derived from Colombian population 
#' @name colombia_sf.ref
#' @docType data
#' @usage colombia_sf.ref
#' @source Ramirez-Velez, R. et al. Triceps and Subscapular Skinfold Thickness Percentiles and Cut-Offs for Overweight and Obesity in a Population-Based Sample of Schoolchildren and Adolescents in Bogota, Colombia. Nutrients 8, (2016).
NULL


#' Parameters of skinfold measures derived from Colombian population 
#' @name who2007.ref
#' @docType data
#' @usage who2007.ref
#' @source Onis, M. de, Onyango, A.W., Borghi, E., Siyam, A., Nishida, C., Siekmann, J., 2007. Development of a WHO growth reference for school-aged children and adolescents. Bulletin of the World health Organization 85, 660-667.
NULL


#' Parameters of skinfold measures derived from Colombian population 
#' @name nl3.ref
#' @docType data
#' @usage nl3.ref
#' @source Fredriks, A. M. et al. Continuing positive secular growth change in The Netherlands 1955-1997. Pediatric research 47, 316-323 (2000).
#' @source Fredriks, A.M., van Buuren, S., Wit, J.M., Verloove-Vanhorick, S.P., 2000. Body index measurements in 1996-7 compared with 1980. Archives of disease in childhood 82, 107-112.
#' @source https://cran.r-project.org/package=AGD
NULL


#' Parameters of serum insulin-like growth factor-I (IGF-I) 
#' @name japan_lab.ref
#' @docType data
#' @usage japan_lab.ref
#' @source Isojima, T., Shimatsu, A., Yokoya, S., Chihara, K., Tanaka, T., Hizuka, N., Teramoto, A., Tatsumi, K., Tachibana, K., Katsumata, N., Horikawa, R., 2012. Standardized centile curves and reference intervals of serum insulin-like growth factor-I (IGF-I) levels in a normal Japanese population using the LMS method. Endocrine Journal 59, 771-780. doi:10.1507/endocrj.EJ12-0110
NULL


#' International Laboratory Parameters Tables
#' @name international_lab.ref
#' @docType data
#' @usage international_lab.ref
#' @source Bidlingmaier, M., Friedrich, N., Emeny, R.T., Spranger, J., Wolthers, O.D., Roswall, J., Koerner, A., Obermayer-Pietsch, B., Huebener, C., Dahlgren, J., others, 2014. Reference intervals for insulin-like growth factor-1 (IGF-I) from birth to senescence: results from a multicenter study using a new automated chemiluminescence IGF-I immunoassay conforming to recent international recommendations. The Journal of Clinical Endocrinology & Metabolism 99, 1712-1721.
#' @source Friedrich, N., Wolthers, O.D., Arafat, A.M., Emeny, R.T., Spranger, J., Roswall, J., Kratzsch, J., Grabe, H.J., Huebener, C., Pfeiffer, A.F.H., Doering, A., Bielohuby, M., Dahlgren, J., Frystyk, J., Wallaschofski, H., Bidlingmaier, M., 2014. Age- and Sex-Specific Reference Intervals Across Life Span for Insulin-Like Growth Factor Binding Protein 3 (IGFBP-3) and the IGF-I to IGFBP-3 Ratio Measured by New Automated Chemiluminescence Assays. The Journal of Clinical Endocrinology & Metabolism 99, 1675-1686. doi:10.1210/jc.2013-3060
NULL


#' Parameters Preterm and  Intrauterine
#' @name preterm.ref
#' @docType data
#' @usage preterm.ref
#' @source Olsen, I.E., Lawson, M.L., Ferguson, A.N., Cantrell, R., Grabich, S.C., Zemel, B.S., Clark, R.H., 2015. BMI Curves for Preterm Infants. PEDIATRICS 135, e572-e581. doi:10.1542/peds.2014-2777
#' @source Olsen, I.E., Groveman, S.A., Lawson, M.L., Clark, R.H., Zemel, B.S., 2010. New intrauterine growth curves based on United States data. Pediatrics 125, e214-224. doi:10.1542/peds.2009-0913
NULL


#' Parameters for serum liver enzymes
#' @name life_liver.ref
#' @docType data
#' @usage life_liver.ref
#' @source Bussler et al, New pediatric percentiles of liver enzyme serum levels (ALT, AST, GGT): effects of age, sex, BMI and pubertal stage, Hepatology 2017
NULL


#' Parameters from the 1990 UK growth study
#' @name uk1990.ref
#' @docType data
#' @usage uk1990.ref
#' @source Cole, T.J., Freeman, J.V., Preece, M.A., 1998. British 1990 growth reference centiles for weight, height, body mass index and head circumference fitted by maximum penalized likelihood. Statistics in medicine 17, 407-429.
#' @source Cole, T.J., Freeman, J.V., Preece, M.A., 1995. Body mass index reference curves for the UK, 1990. Archives of disease in childhood 73, 25-29.
NULL


#' Parameters from recommendations of the German Adiposity Association (2015, AGA)
#' @name aga_15.ref
#' @docType data
#' @usage aga_15.ref
#' @source "Kromeyer-Hauschild K, Moss A, Wabitsch M. Referenzwerte fuer den Body-Mass-Index fuer Kinder, Jugendliche und Erwachsene in Deutschland. Adipositas - Ursachen, Folgeerkrankungen, Therapie. 2015;09(3):123-7."
NULL

#' Parameters from Wuehl et al. blood pressure reference values Germany according to age,
#' from version 0.7.3 unplausible values are replaced by interpolated ones. For the original values
#' check out earlier versions
#' @name bp_wuehl_age.ref
#' @docType data
#' @usage bp_wuehl_age.ref
#' @source "Wuehl E, Witte K, Soergel M, Mehls O, Schaefer F, Hypertension  for the GWG on P. Distribution of 24-h ambulatory blood pressure in children: normalized reference values and role of body dimensions. Journal of Hypertension. 2002 Oct;20(10):1995.", implausible values were replaced by interpolated ones from package version 0.7.4
NULL

#' Parameters from Wuehl et al. blood pressure reference values Germany according to height
#' from version 0.7.3 unplausible values are replaced by interpolated ones. For the original values
#' check out earlier versions
#' @name bp_wuehl_height.ref
#' @docType data
#' @usage bp_wuehl_height.ref
#' @source "Wuehl E, Witte K, Soergel M, Mehls O, Schaefer F, Hypertension  for the GWG on P. Distribution of 24-h ambulatory blood pressure in children: normalized reference values and role of body dimensions. Journal of Hypertension. 2002 Oct;20(10):1995.", implausible values were replaced by interpolated ones from package version 0.7.4
NULL

#' Parameters for different skinfolds
#' @name life_skinfold.ref
#' @docType data
#' @usage life_skinfold.ref
#' @source "Roennecke E, Vogel M, Bussler S, Grafe N, Jurkutat A, Schlingmann M, Koerner A, Kiess W. Age- and sex-related percentiles of skinfold thickness, waist and hip circumference, Waist-to- Hip Ratio and Waist-to-Height Ratio: Results from a population-based paediatric cohort in Germany (LIFE Child). Obesity Facts. 2019."
NULL


#' Parameters for different circumferences and whr and whtr
#' @name life_circ.ref
#' @docType data
#' @usage life_circ.ref
#' @source "Roennecke E, Vogel M, Bussler S, Grafe N, Jurkutat A, Schlingmann M, Koerner A, Kiess W. Age- and sex-related percentiles of skinfold thickness, waist and hip circumference, Waist-to- Hip Ratio and Waist-to-Height Ratio: Results from a population-based paediatric cohort in Germany (LIFE Child). Obesity Facts. 2019."
NULL


#' Parameters for bodyfat (%), fat mass index (FMI) and lean body mass index (LBMI)
#' for Whites, Blacks, and Mexican-Americans
#' @name duran_bf.ref
#' @docType data
#' @usage duran_bf.ref
#' @source "Duran I, Martakis K, Rehberg M, Stark C, Schafmeyer L, Schoenau E. Reference Centiles for the Evaluation of Nutritional Status in Children using Body Fat Percentage, Fat Mass and Lean Body Mass Index. Journal of Clinical Densitometry [Internet] 2019 [cited 2019 Mar 19];Available from: https://linkinghub.elsevier.com/retrieve/pii/S1094695018302622"
NULL


#' Parameters for different carotid artery intima-media thickness and distensibility dependent on age
#' @name doyon_age.ref
#' @docType data
#' @usage doyon_age.ref
#' @source "Doyon A, Kracht D, Bayazit AK, et al. Carotid artery intima-media thickness and distensibility in children and adolescents: reference values and role of body dimensions. Hypertension 2013;62(3):550-6"
NULL


#' Parameters for different carotid artery intima-media thickness and distensibility
#' dependent on height
#' @name doyon_height.ref
#' @docType data
#' @usage doyon_height.ref
#' @source "Doyon A, Kracht D, Bayazit AK, et al. Carotid artery intima-media thickness and distensibility in children and adolescents: reference values and role of body dimensions. Hypertension 2013;62(3):550-6"
NULL


#' Parameters for different bone parameters
#' @name bone.ref
#' @docType data
#' @usage bone.ref
#' @source "Geserick M, Vogel M, Eckelt F, et al. Children and adolescents with obesity have reduced serum bone turnover markers and 25-hydroxyvitamin D but increased parathyroid hormone concentrations – Results derived from new pediatric reference ranges. Bone 2020;132:115124 and Weber et al. unpublishedfor VitD binding protein"
NULL


#' Parameters for 5 subtests of the KiGGS Motorik Module
#' @name motor.ref
#' @docType data
#' @usage motor.ref
#' @source "Sobek et al. In progress"
NULL


#' Parameters for height of normal weight and obese children from the CrescNet database
#' dependent on height
#' @name cn.ref
#' @docType data
#' @usage cn.ref
#' @source "Kempf et al. In progress"
NULL



#' Parameters for TSH, FT3, FT4 from the LIFE Child cohort
#' @name life_thyr.ref
#' @docType data
#' @usage life_thyr.ref
#' @source "Surup H., Vogel M., Koerner A., Hiemisch A., Oelkers L., Willenberg A., Kiess W., Kratzsch J. (2021). BMI and puberty have to be included into the interpretation of TSH, FT3 and FT4 measurements by new pediatric reference intervals. THYROID."
NULL


#' Parameters for different metabolom parameters from the LIFE Child cohort
#' @name metabolom.ref
#' @docType data
#' @usage metabolom.ref
#' @source "Hirschel, J., Vogel, M., Baber, R., Garten, A., Beuchel, C., Dietz, Y., Dittrich, J., Körner, A., Kiess, W., & Ceglarek, U. (2020). Relation of Whole Blood Amino Acid and Acylcarnitine Metabolome to Age, Sex, BMI, Puberty, and Metabolic Markers in Children and Adolescents. Metabolites, 10(4), 149. https://doi.org/10.3390/metabo10040149"
NULL

#' Parameters for different metabolom parameters from the LIFE Child cohort
#' @name life_cysc.ref
#' @docType data
#' @usage life_cysc.ref
#' @source "Ziegelasch N, Vogel M, Müller E, et al. Cystatin C Serum Levels in Healthy Children Are Related to Age, Gender, and Pubertal Stage. Pediatr Nephrol 2019; 34: 449–57."
NULL

#' hs-Troponin T and NT-proBNP from the LIFE Child cohort
#' @name life_heart.ref
#' @docType data
#' @usage life_heart.ref
#' @source "Kiess A, Green J, Willenberg A, et al. Age-dependent reference values for hs-Troponin T and NT-proBNP and determining factors in a cohort of healthy children (The LIFE child study). Pediatric Cardiology 2022. Accepted"
NULL


#' Parameters for the German MoMo study (sports test)
#' @name momo.ref
#' @docType data
#' @usage momo.ref
#' @source "Niessner C, Utesch T, Oriwol D, et al. Representative Percentile Curves of Physical Fitness From Early Childhood to Early Adulthood: The MoMo Study. Front Public Health 2020;8. Available from: https://www.frontiersin.org/articles/10.3389/fpubh.2020.00458/full?report=reader"
NULL


#' IGF-I and IGF-BP3 from the LIFE Child cohort
#' @name life_igf.ref
#' @docType data
#' @usage life_igf.ref
#' @source "Hoerenz C, Vogel M, Wirkner K. BMI and contraceptives affect new age-, sex-, and puberty-adjusted IGF-﻿I and IGFBP-﻿3 reference ranges across life span. JCEM 2022 (in (minor) revision)."
NULL


#' Parameters for Cardiovascular Magnetic Resonance
#' @name kawel_boehm.ref
#' @docType data
#' @usage kawel_boehm.ref
#' @source "Kawel-Boehm N, Hetzel SJ, Ambale-Venkatesh B, et al. Reference ranges (“normal values”) for cardiovascular magnetic resonance (CMR) in adults and children: 2020 update. Journal of Cardiovascular Magnetic Resonance 2020;22(1):87."
NULL


#' Parameters for fibroscan from the LIFE Child cohort
#' @name life_fibroscan.ref
#' @docType data
#' @usage life_fibroscan.ref
#' @source "preliminary reference values cap med and e med from fibroscan in the life child study. Publication (Puasa et al) in preparation."
NULL
