% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple.testing.correct.R
\name{multiple.testing.correct}
\alias{multiple.testing.correct}
\title{multiple.testing.correct}
\usage{
multiple.testing.correct(interaction.data, bait.level = TRUE)
}
\arguments{
\item{interaction.data}{Data table of interaction calls. Must contain columns p.value and bait.id.}

\item{bait.level}{Logical indicating whether multiple testing correction should be performed per bait.}
}
\value{
Original data table with new column
	\item{q.value}{FDR-corrected p-value}
}
\description{
Perform multiple testing correction on p-values from interaction test.
	By default, multiple testing correction is applied per bait. To change this
	to a global multiple testing correction, set \code{bait.level = FALSE}.
}
\examples{
	data(bre80);
results <- fit.model(bre80);	
adjusted.results <- multiple.testing.correct(results);

}
