% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chest_lm.R
\name{chest_lm}
\alias{chest_lm}
\title{Assessing confounding effects using Linear regression models}
\usage{
chest_lm(
  crude,
  xlist,
  data,
  method = "qr",
  na_omit = TRUE,
  indicate = FALSE,
  plus = "  + ",
  ...
)
}
\arguments{
\item{crude}{An object of \emph{formula} for initial model, generally crude model.
However, any other variables can also be included here as the initial model.}

\item{xlist}{A \emph{vector} of characters with all variable names of potential confounders.}

\item{data}{\emph{Data frame}.}

\item{method}{The method to be used; see \pkg{'lm'}.}

\item{na_omit}{Remove all missing values.}

\item{indicate}{indicate progress}

\item{plus}{Change the \code{+} sign before variable names.}

\item{...}{Further optional arguments.}
}
\value{
A table with effect estimates and their changes at all steps.
}
\description{
\code{'chest_lm'} is used to assess confounding effects using Linear Regression Models.
It presents linear regression coefficients as effect estimates and
changes when other variables are added sequentially to the model.
}
\examples{
vlist<-c("Age", "Sex", "Married", "Cancer", "CVD","Education", "Income")
chest_lm(crude = "BMI ~ Diabetes", xlist = vlist, data = diab_df, na_omit = TRUE)
}
\seealso{
\code{'lm'} of \pkg{'stats'}
}
