% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/molNetPlot.R
\name{molNetPlot}
\alias{molNetPlot}
\title{Plot molecular networks}
\usage{
molNetPlot(
  sampleData,
  networkObject,
  groupData = NULL,
  npcTable = NULL,
  plotNames = FALSE,
  layout = "kk"
)
}
\arguments{
\item{sampleData}{Data frame with the relative concentration of each
compound (column) in every sample (row).}

\item{networkObject}{A network object, as created by the
\code{\link{molNet}} function. Note that this is only the network object,
which is one of the elements in the list outputted by \code{\link{molNet}}.
The network is extracted as \code{molNetOutput$networkObject}.}

\item{groupData}{Grouping data (e.g. population, species etc.).
If supplied, a separate network will be created for each group.
Should be either a vector, or a data frame with a single column.}

\item{npcTable}{It is optional but recommended to supply an
\code{\link{NPCTable}}. This will result in network nodes being
coloured by their NPC pathway classification.}

\item{plotNames}{Indicates if compounds names should be included
in the molecular network plot.}

\item{layout}{Layout used by \code{\link[ggraph]{ggraph}} when creating
the network. The default chosen here, \code{"kk"}, is the the Kamada-Kawai
layout algorithm which in most cases should produce a visually
pleasing network. Another useful option is \code{"circle"}, which puts all
nodes in a circle, for easier comparisons between different networks.}
}
\value{
A plot with one or more molecular networks.
}
\description{
Function to conveniently create a basic plot of the molecular network
created by the \code{\link{molNet}} function. Molecular networks can be
used to illustrate the biosynthetic/structural similarity of
phytochemical compounds in a sample, while simultaneously visualizing
their relative concentrations. In the network, nodes are compounds,
with node sizes or node colours representing the relative concentrations
of compounds. Edges connects nodes, with edge widths representing
compound similarity.
}
\details{
The network object from \code{\link{molNet}} and \code{sampleData} have to
be supplied. In addition, \code{groupData} and/or an \code{\link{NPCTable}}
can be supplied. If an NPCTable is supplied, which is recommended,
node colours will represent NPC pathways, and node sizes the relative
concentration of the compounds. Edge widths represent compound similarity,
and only edges with similarity values above the \code{cutOff} value
in the \code{\link{molNet}} function will be plotted.
If \code{groupData} is supplied, one network will be created for each group.
When \code{groupData} but not an \code{\link{NPCTable}} is supplied,
compounds missing (i.e. having a mean of 0) from
specific groups are plotted as triangles. When \code{groupData}
and an \code{\link{NPCTable}} is supplied, compounds missing from
specific groups have a white fill. Additionally, in both cases, edges
connecting to missing compounds are lighter coloured. These graphical
styles are done so that networks are more easy to compare across groups.
}
\examples{
data(minimalSampData)
data(minimalNPCTable)
data(minimalMolNet)
groups <- c("A", "A", "B", "B")
molNetPlot(minimalSampData, minimalMolNet)
molNetPlot(minimalSampData, minimalMolNet, groups)
molNetPlot(minimalSampData, minimalMolNet, plotNames = TRUE)

data(alpinaSampData)
data(alpinaPopData)
data(alpinaMolNet)
data(alpinaNPCTable)
molNetPlot(sampleData = alpinaSampData, networkObject = alpinaMolNet,
npcTable = alpinaNPCTable)
}
