% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ord_res_fun.R
\name{phase_space}
\alias{phase_space}
\title{Phase space, linearized model}
\usage{
phase_space(x)
}
\arguments{
\item{x}{an \code{ord_res} object}
}
\value{
Returns a \code{lm} class object.
}
\description{
Given an \code{ord_res} object, this function returns the linearized model
that best fits the data in the phase space.
\code{ord_res} object can be obtained using the function \code{\link[=det_order]{det_order()}}.
}
\examples{
t <- c(0, 4, 8, 12, 16, 20)
conc <- c(1, 0.51, 0.24, 0.12, 0.07, 0.02)
dframe <- data.frame(t, conc)
res <- det_order(dframe)

phase_space(res)
}
\seealso{
\code{\link[=det_order]{det_order()}}, \code{\link[=kin_regr]{kin_regr()}}, \code{\link[=results]{results()}}, \code{\link[stats:lm]{stats::lm()}}
}
