% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_visualization.r
\name{sug_manip_var}
\alias{sug_manip_var}
\title{Suggest a manipulation variable}
\usage{
sug_manip_var(attr_df, primary_obs, comparison_obs)
}
\arguments{
\item{attr_df}{A data frame of local explanation attributions.}

\item{primary_obs}{The rownumber of the primary observation. Its local
attribution becomes the 1d projection basis, and the point it highlighted
as a dashed line.}

\item{comparison_obs}{The rownumber of the comparison observation. Point
is highlighted as a dotted line.}
}
\value{
A single number of the variable with the largest difference of
attribution (basis) variables.
}
\description{
Suggest the number of the variable with the largest difference in attribution
between the primary and comparison observations.
}
\examples{
library(cheem)

## Regression setup
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## Suggest the number of a variable to manipulate
sug_manip_var(ames_rf_shap, primary_obs = 1, comparison_obs = 2)
## This can be used to find a basis to start the radial tour.
# ?radial_cheem_tour
}
\seealso{
\code{\link[=radial_cheem_tour]{radial_cheem_tour()}}

Other cheem utility: 
\code{\link{as_logical_index}()},
\code{\link{color_scale_of}()},
\code{\link{contains_nonnumeric}()},
\code{\link{is_discrete}()},
\code{\link{is_diverging}()},
\code{\link{linear_tform}()},
\code{\link{logistic_tform}()},
\code{\link{problem_type}()},
\code{\link{rnorm_from}()},
\code{\link{sug_basis}()}
}
\concept{cheem utility}
