% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{check_no_attributes}
\alias{check_no_attributes}
\title{Check No Attributes}
\usage{
check_no_attributes(x, names = TRUE, class = TRUE,
  x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{names}{A flag specifying whether names should be considered an attribute.}

\item{class}{A flag specifying whether class should be considered an attribute.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks an object has no attributes.
}
\examples{
x <- 1
attributes(x) <- list(y = 2L)
check_no_attributes(x, error = FALSE)
}
\seealso{
\code{\link{check_attributes}}
}
