% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing.R
\name{check_missing_colnames}
\alias{check_missing_colnames}
\title{Check Missing Colnames}
\usage{
check_missing_colnames(x, colnames, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The data to check.}

\item{colnames}{A character vector of the column names that must be missing from x.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Check Missing Colnames
}
\examples{
data <- data.frame(x = 1, y = 2, z = 0)
check_missing_colnames(data, c("y", "x", "a"), error = FALSE)
check_missing_colnames(data, "a", error = FALSE)
}
