% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datetime.R
\name{check_datetime}
\alias{check_datetime}
\title{Check Date Time}
\usage{
check_datetime(x, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks if x is a datetime (non-missing POSIXt scalar).
}
\examples{
check_datetime(Sys.Date(), error = FALSE)
check_datetime(Sys.time(), error = FALSE)
}
