% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkScalar.r
\name{checkScalar}
\alias{assertScalar}
\alias{assert_scalar}
\alias{checkScalar}
\alias{expect_scalar}
\alias{testScalar}
\alias{test_scalar}
\title{Check if an argument is a single atomic value}
\usage{
checkScalar(x, na.ok = FALSE)

assertScalar(x, na.ok = FALSE, add = NULL, .var.name = NULL)

assert_scalar(x, na.ok = FALSE, add = NULL, .var.name = NULL)

testScalar(x, na.ok = FALSE)

test_scalar(x, na.ok = FALSE)

expect_scalar(x, na.ok = FALSE, info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[\code{NULL} || \code{character(1)}]\cr
Name of the checked object to print in error message. If \code{NULL},
the name will be heuristically determined via \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertScalar}/\code{assert_scalar}
 throws an error message, \code{testScalar}/\code{test_scalar}
 returns \code{FALSE},
 and \code{checkScalar} returns a string with the error message.
 The function \code{expect_scalar} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a single atomic value
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testScalar(1)
testScalar(1:10)
}
\seealso{
Other scalars: \code{\link{checkCount}},
  \code{\link{checkFlag}}, \code{\link{checkInt}},
  \code{\link{checkNumber}}, \code{\link{checkScalarNA}},
  \code{\link{checkString}}
}

