% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkCount.r
\name{checkCount}
\alias{assertCount}
\alias{assert_count}
\alias{checkCount}
\alias{expect_count}
\alias{testCount}
\alias{test_count}
\title{Check if an argument is a count}
\usage{
checkCount(x, na.ok = FALSE, positive = FALSE,
  tol = sqrt(.Machine$double.eps))

assertCount(x, na.ok = FALSE, positive = FALSE,
  tol = sqrt(.Machine$double.eps), add = NULL, .var.name = NULL)

assert_count(x, na.ok = FALSE, positive = FALSE,
  tol = sqrt(.Machine$double.eps), add = NULL, .var.name = NULL)

testCount(x, na.ok = FALSE, positive = FALSE,
  tol = sqrt(.Machine$double.eps))

test_count(x, na.ok = FALSE, positive = FALSE,
  tol = sqrt(.Machine$double.eps))

expect_count(x, na.ok = FALSE, positive = FALSE,
  tol = sqrt(.Machine$double.eps), info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{positive}{[\code{logical(1)}]\cr
Must \code{x} be positive (>= 1)?
Default is \code{FALSE}, allowing 0.}

\item{tol}{[\code{double(1)}]\cr
Numerical tolerance used to check whether a double or complex can be converted.
Default is \code{sqrt(.Machine$double.eps)}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[\code{NULL} || \code{character(1)}]\cr
Name of the checked object to print in error message. If \code{NULL},
the name will be heuristically determined via \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertCount}/\code{assert_count}
 throws an error message, \code{testCount}/\code{test_count}
 returns \code{FALSE},
 and \code{checkCount} returns a string with the error message.
 The function \code{expect_count} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
A count is defined as non-negative integerish value.
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testCount(1)
testCount(-1)
}
\seealso{
Other scalars: \code{\link{checkFlag}},
  \code{\link{checkInt}}, \code{\link{checkNumber}},
  \code{\link{checkScalarNA}}, \code{\link{checkScalar}},
  \code{\link{checkString}}
}

