% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert.r
\name{assert}
\alias{assert}
\title{Combine multiple checks into one assertion}
\usage{
assert(..., .var.name)
}
\arguments{
\item{...}{[any]\cr
List of calls to check functions.}

\item{.var.name}{[character(1)]\cr
Name of object to check. Defaults to a heuristic to determine
the name of the first argument of the first call.}
}
\value{
Throws an error if all checks fails and invisibly returns
 \code{TRUE} otherwise.
}
\description{
You can call this function with an arbitrary number of of \code{check*}
functions. The resulting assertion is successful, if at least one
check evaluates to \code{TRUE}. Otherwise, \code{assert} throws an
informative error messages where the messages from all \code{check*}
functions are collected.
}
\examples{
x = 1:10
assert(checkNull(x), checkInteger(x, any.missing = FALSE))
\dontrun{
x = 1
assert(checkChoice(x, c("a", "b")), checkDataFrame(x))
}
}

