% Generated by roxygen2 (4.0.2): do not edit by hand
\name{checkAccess}
\alias{assertAccess}
\alias{checkAccess}
\alias{testAccess}
\title{Check file system access rights}
\usage{
checkAccess(x, access = "")

assertAccess(x, access = "", .var.name)

testAccess(x, access = "")
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{access}{[\code{character(1)}]\cr
Single string containing possible characters \sQuote{r}, \sQuote{w} and \sQuote{x} to
force a check for read, write or execute access rights, respectively.
Write and executable rights are not checked on Windows.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertAccess} throws an error message,
 \code{testAccess} returns \code{FALSE} and \code{checkAccess} returns
 a string with the error message.
}
\description{
Check file system access rights
}
\examples{
# Is R's home directory readable?
testAccess(R.home(), "r")

# Is R's home directory writeable?
testAccess(R.home(), "w")
}
\seealso{
Other filesystem: \code{\link{assertDirectory}},
  \code{\link{checkDirectory}},
  \code{\link{testDirectory}}; \code{\link{assertFile}},
  \code{\link{checkFile}}, \code{\link{testFile}};
  \code{\link{assertPathForOutput}},
  \code{\link{checkPathForOutput}},
  \code{\link{testPathForOutput}}
}

