% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalars.R
\name{val_count}
\alias{val_count}
\alias{val_find}
\alias{which_val}
\alias{val_replace}
\alias{na_replace}
\alias{val_rm}
\alias{na_count}
\alias{na_find}
\alias{na_rm}
\title{Efficient functions for counting, finding, replacing and removing scalars}
\usage{
val_count(x, value, recursive = TRUE)

val_find(x, value, invert = FALSE)

which_val(x, value, invert = FALSE)

val_replace(x, value, replace, recursive = TRUE)

na_replace(x, replace, recursive = TRUE)

val_rm(x, value)

na_count(x, recursive = TRUE)

na_find(x, invert = FALSE)

na_rm(x)
}
\arguments{
\item{x}{A vector, list, data frame or matrix.}

\item{value}{A scalar value to count, find, replace or remove.}

\item{recursive}{Should values in a list be counted or replaced recursively?
Default is \code{TRUE} and very useful for data frames.}

\item{invert}{Should \code{which_val} find locations of
everything except specified value? Default is \code{FALSE}.}

\item{replace}{Replacement scalar value.}
}
\value{
\code{val_count()} returns the number of times a scalar value appears in a vector
or list. \cr
\code{val_find()} returns the index locations of that scalar value. \cr
\code{val_replace()} replaces a specified scalar value with a replacement scalar
value. If no instances of said value are found then the input x is returned
as is. \cr
\code{na_replace()} is a convenience function
equivalent to \code{val_replace(x, NA, ...)}. \cr
\code{val_rm()} removes all instances of a specified scalar value.
If no instances are found, the original input x is returned as is.
}
\description{
These are primarily intended as very fast scalar-based functions
for developers.
They are particularly useful for working with \code{NA} values in a fast
and efficient manner.
}
\details{
The \code{val_} functions allow you to very efficiently work with
scalars, i.e length 1 vectors. Many common common operations like
counting the occurrence of \code{NA} or zeros, e.g. \code{sum(x == 0)} or
\code{sum(is.na(x))} can be replaced more efficiently with
\code{val_count(x, 0)} and \code{na_count(x)} respectively.

At the moment these functions only work for
integer, double and character vectors with the exception of the \code{NA}
functions.
They are intended mainly for developers who wish to write cheaper code
and reduce expensive vector operations.
\itemize{
\item \code{val_count()} - Counts occurrences of a value
\item \code{val_find()} Finds locations (indices) of a value
\item \code{val_replace()} - Replaces value with another value
\item \code{val_rm()} - Removes occurrences of value from an object
}

There are \code{NA} equivalent convenience functions.
\itemize{
\item \code{na_count()} == \code{val_count(x, NA)}
\item \code{na_find()} == \code{val_find(x, NA)}
\item \code{na_replace()} == \code{val_replace(x, NA)}
\item \code{na_rm()} == \code{val_rm(x, NA)}
}

\code{val_count()} and \code{val_replace()} can work recursively. For example,
when applied to a data frame, \code{na_replace} will replace \code{NA} values across
the entire data frame with the specified replacement value.

In 'cheapr' function-naming conventions have not been consistent but
going forward
all scalar functions (including the \code{NA} convenience functions) will be
prefixed with 'val_' and 'na_' respectively.
Functions named with the older naming scheme like \code{which_na} may be
removed at some point in the future.
}
