% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extras.R
\name{setdiff_}
\alias{setdiff_}
\alias{intersect_}
\alias{cut_numeric}
\alias{cut.integer64}
\alias{\%in_\%}
\alias{\%!in_\%}
\alias{enframe_}
\alias{deframe_}
\alias{sample_}
\alias{val_insert}
\alias{na_insert}
\alias{vector_length}
\title{Extra utilities}
\usage{
setdiff_(x, y, dups = TRUE)

intersect_(x, y, dups = TRUE)

cut_numeric(
  x,
  breaks,
  labels = NULL,
  include.lowest = FALSE,
  right = TRUE,
  dig.lab = 3L,
  ordered_result = FALSE,
  ...
)

\method{cut}{integer64}(x, ...)

x \%in_\% table

x \%!in_\% table

enframe_(x, name = "name", value = "value")

deframe_(x)

sample_(x, size = vector_length(x), replace = FALSE, prob = NULL)

val_insert(x, value, n = NULL, prop = NULL)

na_insert(x, n = NULL, prop = NULL)

vector_length(x)
}
\arguments{
\item{x}{A vector or data frame.}

\item{y}{A vector or data frame.}

\item{dups}{Should duplicates be kept? Default is \code{TRUE}.}

\item{breaks}{See \code{?cut}.}

\item{labels}{See \code{?cut}.}

\item{include.lowest}{See \code{?cut}.}

\item{right}{See \code{?cut}.}

\item{dig.lab}{See \code{?cut}.}

\item{ordered_result}{See \code{?cut}.}

\item{...}{Further arguments passed onto \code{cut} or \code{set.seed}.}

\item{table}{See \code{?collapse::fmatch}}

\item{name}{The column name to assign the names of a vector.}

\item{value}{The column name to assign the values of a vector.}

\item{size}{See \code{?sample}.}

\item{replace}{See \code{?sample}.}

\item{prob}{See \code{?sample}.}

\item{n}{Number of scalar values (or \code{NA}) to insert
randomly into your vector.}

\item{prop}{Proportion of scalar values (or \code{NA}) values to insert
randomly into your vector.}
}
\value{
\verb{enframe()_} converts a vector to a data frame. \cr
\verb{deframe()_} converts a 1-2 column data frame to a vector. \cr
\code{intersect_()} returns a vector of common values between \code{x} and \code{y}. \cr
\code{setdiff_()} returns a vector of values in \code{x} but not \code{y}. \cr
\code{cut_numeric()} places values of a numeric vector into buckets, defined
through the \code{breaks} argument and returns a factor unless \code{labels = FALSE},
in which case an integer vector of break indices is returned. \cr
\verb{\%in_\%} and \verb{\%!in_\%} both return a logical vector signifying if the values of
\code{x} exist or don't exist in \code{table} respectively. \cr
\code{sample_()} is an alternative to \code{sample()} that natively samples
data frame rows through \code{sset()}. It also does not have a special case when
\code{length(x)} is 1. \cr
\code{val_insert} inserts scalar values randomly into your vector.
Useful for replacing lots of data with a single value. \cr
\code{na_insert} inserts \code{NA} values randomly into your vector.
Useful for generating missing data. \cr
\code{vector_length} behaves mostly like \code{NROW()} except
for matrices in which it matches \code{length()}.
}
\description{
Extra utilities
}
\details{
\code{intersect_()} and \code{setdiff_()} are faster and more efficient
alternatives to \code{intersect()} and \code{setdiff()} respectively. \cr
\code{enframe_()} and \code{deframe_()} are faster alternatives to
\code{tibble::enframe()} and \code{tibble::deframe()} respectively. \cr
\code{cut_numeric()} is a faster and more efficient alternative to
\code{cut.default()}.
}
