#' ChatGPT: Optimize Code
#'
#' @param code The code to be optimized by ChatGPT. If not provided, it will use what's copied on
#'   the clipboard.
#'
#' @examples
#' \dontrun{
#' cat(optimize_code("i <- 10\nwhile (i > 0) {\n  i <- i - 1\n  print(i)\n}"))
#' }
#'
#' @importFrom clipr read_clip
#'
#' @return A character value with the response generated by ChatGPT.
#'
#' @export
#'
optimize_code <- function(code = clipr::read_clip(allow_non_interactive = TRUE)) {
  code <- paste(gsub('"', "'", code), collapse = "\n")
  prompt <- paste0('Optimize the following R code: "', code, '"')
  parse_response(gpt_get_completions(prompt))
}
