#' ChatGPT: Find Issues in Code
#'
#' @param code The code to be analyzed by ChatGPT.
#'
#' @examples
#' \dontrun{
#' cat(find_issues_in_code("i <- 0\nwhile (i < 0) {\n  i <- i - 1\n}"))
#' }
#'
#' @return A character value with the response generated by ChatGPT.
#'
#' @export
#'
find_issues_in_code <- function(code) {
  prompt <- paste0('Find issues or bugs in the following R code: "', code, '"')
  parse_response(gpt_get_completions(prompt))
}
