% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/img2img_upscale_StableDiffusion4R.R
\name{img2img_upscale_StableDiffusion4R}
\alias{img2img_upscale_StableDiffusion4R}
\title{Stable Diffusion Image to Image Up-scaling Transformation}
\usage{
img2img_upscale_StableDiffusion4R(
  init_image_path,
  width = 1024,
  engine_id = "esrgan-v1-x2plus",
  api_host = "https://api.stability.ai",
  Original_Image = TRUE,
  Flop = TRUE,
  Flip = FALSE,
  api_key = Sys.getenv("DreamStudio_API_KEY"),
  verbose = TRUE
)
}
\arguments{
\item{init_image_path}{A string. This is the path to the image file to be used as the basis for the image to image transformation. Should be a valid PNG file.}

\item{width}{An integer. The desired width of the up-scaled image. Default is 1024.}

\item{engine_id}{A string. The engine id to be used in the API. Default is 'esrgan-v1-x2plus'.
Other possible value is 'stable-diffusion-x4-latent-upscaler'.}

\item{api_host}{A string. The host of the Stable Diffusion API. Default is 'https://api.stability.ai'.}

\item{Original_Image}{A logical. If TRUE, the original image is included in the result. Default is TRUE.}

\item{Flop}{A logical. If TRUE, the up-scaled image is flopped. Default is TRUE.}

\item{Flip}{A logical. If FALSE, the up-scaled image is not flipped. Default is FALSE.}

\item{api_key}{A string. The API key for the Stable Diffusion API. It is read from the 'DreamStudio_API_KEY' environment variable by default.}

\item{verbose}{A logical flag to print the message Default is TRUE.}
}
\value{
A list of image up-scaled from the initial image.
}
\description{
This function creates a higher resolution version of an input image via the Stable Diffusion API.
}
\examples{
\dontrun{
init_image_path <- system.file("images", "JP_castle.png", package = "chatAI4R")
result <- img2img_upscale_StableDiffusion4R(init_image_path)
Display(result, write_file = TRUE)
}
}
\author{
Satoshi Kume
}
